/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.Apitef;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.entrada.ICapturaNumeroPremios;
import com.csi.ctfclient.operacoes.entrada.ICertificadoDUKPT;
import com.csi.ctfclient.operacoes.entrada.IDadoPlano;
import com.csi.ctfclient.operacoes.entrada.IDadoTransacao;
import com.csi.ctfclient.operacoes.entrada.IDadosRetorno1F;
import com.csi.ctfclient.operacoes.entrada.IDevices;
import com.csi.ctfclient.operacoes.entrada.IEntradaApiTef;
import com.csi.ctfclient.operacoes.entrada.IIdentTerminal;
import com.csi.ctfclient.operacoes.entrada.IIntegracao;
import com.csi.ctfclient.operacoes.entrada.INsuTransacao;
import com.csi.ctfclient.operacoes.entrada.INumeroCupom;
import com.csi.ctfclient.operacoes.entrada.IOrigemTransacao;
import com.csi.ctfclient.operacoes.entrada.IProcess;
import com.csi.ctfclient.operacoes.entrada.IProdutoDinamico;
import com.csi.ctfclient.operacoes.entrada.ISaidaApiTef;
import com.csi.ctfclient.operacoes.entrada.ITaxaEmbarque;
import com.csi.ctfclient.operacoes.entrada.ITaxaServico;
import com.csi.ctfclient.operacoes.entrada.IValorTransacao;
import com.csi.ctfclient.operacoes.model.ControladorInicioDia;
import com.csi.ctfclient.operacoes.model.DadosInicioDia;
import com.csi.ctfclient.operacoes.model.Embarque;
import com.csi.ctfclient.operacoes.model.Plano;
import com.csi.ctfclient.operacoes.model.PlanoAPrazo;
import com.csi.ctfclient.operacoes.model.PlanoAVista;
import com.csi.ctfclient.operacoes.model.PlanoAdministradoraIATA;
import com.csi.ctfclient.operacoes.model.PlanoCDC;
import com.csi.ctfclient.operacoes.model.PlanoParcelado;
import com.csi.ctfclient.operacoes.model.PlanoPreDatado;
import com.csi.ctfclient.operacoes.model.Produto;
import com.csi.ctfclient.operacoes.model.Servico;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class MicAbstractSolicitacaoTEF {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    private Logger logger = CTFClientLogger.getCTFClient();

    protected abstract String getCodigoTransacao(Process var1) throws IllegalStateException;

    public String execute(Process dados) throws ExcecaoApiAc {
        EntradaApiTefC entradaApiTefC = new EntradaApiTefC();
        this.initEntradaApiTefC(entradaApiTefC, dados);
        this.montaDisplay(dados);
        SaidaApiTefC saidaApiTefC = this.solicitaTEF(entradaApiTefC, dados);
        return this.testaRetorno(saidaApiTefC, dados);
    }

    protected void initEntradaApiTefC(EntradaApiTefC entradaApiTefC, Process dados) throws ExcecaoApiAc {
        INsuTransacao dadosNsu;
        ITaxaServico dadosServico;
        Servico servico;
        ITaxaEmbarque dadosTaxaEmbarque;
        Embarque embarque;
        Produto produto;
        IValorTransacao dadosValorTransacao;
        BigDecimal valorTransacao = new BigDecimal(0);
        String operacao = this.getCodigoTransacao(dados);
        entradaApiTefC.setOperacao(operacao);
        this.logger.debug((Object)("initEntradaApiTefC:operacao=" + operacao));
        if (dados instanceof IValorTransacao && (dadosValorTransacao = (IValorTransacao)((Object)dados)).getValorTransacao() != null) {
            entradaApiTefC.setValorTransacao(dadosValorTransacao.getValorTransacao());
            valorTransacao = dadosValorTransacao.getValorTransacao();
            this.logger.debug((Object)("initEntradaApiTefC:valor da transa\u00e7\u00e3o=" + valorTransacao));
        }
        if (dados instanceof IDadoTransacao) {
            IDadoTransacao dadosTransacao = (IDadoTransacao)((Object)dados);
            entradaApiTefC.setNumeroTransacao(dadosTransacao.getNumeroTransacao());
            this.logger.debug((Object)("initEntradaApiTefC:n\u00famero da transa\u00e7\u00e3o=" + dadosTransacao.getNumeroTransacao()));
        }
        if (dados instanceof ISaidaApiTef) {
            ISaidaApiTef dadosSaidaApiTef = (ISaidaApiTef)((Object)dados);
            SaidaApiTefC saidaApiTefC = dadosSaidaApiTef.getSaidaApiTef();
            entradaApiTefC.setTimeoutCtf(saidaApiTefC.getTimeOutCTF());
            this.logger.debug((Object)("initEntradaApiTefC:timeout-ctf=" + saidaApiTefC.getTimeOutCTF()));
        }
        if (dados instanceof IProdutoDinamico && (produto = ((IProdutoDinamico)((Object)dados)).getProdutoDinamico()) != null) {
            entradaApiTefC.setCodigoProduto(produto.getCodigo());
            this.logger.debug((Object)("initEntradaApiTefC:c\u00f3digo do produto=" + produto.getCodigo()));
            entradaApiTefC.setCodigoBandeira(produto.getCodigoBandeira());
            this.logger.debug((Object)("initEntradaApiTefC:c\u00f3digo da bandeira=" + produto.getCodigoBandeira()));
            entradaApiTefC.setFluxoTef(produto.getKeyFluxo());
            this.logger.debug((Object)("initEntradaApiTefC:key fluxo=" + produto.getKeyFluxo()));
        }
        if (dados instanceof ITaxaEmbarque && (embarque = (dadosTaxaEmbarque = (ITaxaEmbarque)((Object)dados)).getTaxaEmbarque()) != null) {
            entradaApiTefC.setValorTaxaEmbarque(embarque.getValorEmbarque());
            this.logger.debug((Object)("initEntradaApiTefC:valor da taxa de embarque=" + embarque.getValorEmbarque()));
        }
        if (dados instanceof ITaxaServico && (servico = (dadosServico = (ITaxaServico)((Object)dados)).getServico()) != null) {
            entradaApiTefC.setValorTaxaServico(servico.getValorServico());
            this.logger.debug((Object)("initEntradaApiTefC:valor da taxa de servi\u00e7o=" + servico.getValorServico()));
        }
        if (dados instanceof IDadoPlano) {
            IDadoPlano dadosPlano = (IDadoPlano)((Object)dados);
            Plano plano = dadosPlano.getTipoFinanciamento();
            if (plano instanceof PlanoCDC) {
                PlanoCDC planoCDC = (PlanoCDC)plano;
                entradaApiTefC.setNumeroParcelas(planoCDC.getNumeroParcela());
                this.logger.debug((Object)("initEntradaApiTefC:n\u00famero de parcelas=" + planoCDC.getNumeroParcela()));
                if (planoCDC.getData1parcela() != null) {
                    entradaApiTefC.setDataVencimento(planoCDC.getData1parcela());
                    this.logger.debug((Object)("initEntradaApiTefC:data 1 parcela:plano CDC=" + planoCDC.getData1parcela()));
                }
                if (planoCDC.getValorEntrada() != null) {
                    entradaApiTefC.setValorEntrada(planoCDC.getValorEntrada());
                    this.logger.debug((Object)("initEntradaApiTefC:valor da entrada=" + planoCDC.getValorEntrada()));
                }
                if (planoCDC.getValorParcela() != null) {
                    entradaApiTefC.setValorParcela(planoCDC.getValorParcela());
                    this.logger.debug((Object)("initEntradaApiTefC:valor da parcela=" + planoCDC.getValorParcela()));
                }
            } else if (plano instanceof PlanoParcelado) {
                PlanoParcelado planoParcelado = (PlanoParcelado)plano;
                int numeroParcelas = planoParcelado.getNumeroParcela();
                entradaApiTefC.setNumeroParcelas(numeroParcelas);
                this.logger.debug((Object)("initEntradaApiTefC:n\u00famero de parcelas=" + numeroParcelas));
                BigDecimal valorParcela = valorTransacao.divide(new BigDecimal(numeroParcelas), 2, 6);
                BigDecimal totalTruncado = valorParcela.multiply(new BigDecimal(numeroParcelas));
                BigDecimal valor1Parcela = valorParcela.add(valorTransacao.subtract(totalTruncado));
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
                StringBuffer bit62Formatado = new StringBuffer();
                if (planoParcelado.getData1parcela() != null) {
                    entradaApiTefC.setDataVencimento(planoParcelado.getData1parcela());
                    this.logger.debug((Object)("initEntradaApiTefC:data 1 parcela:plano parcelado=" + planoParcelado.getData1parcela()));
                    Calendar calendar = GregorianCalendar.getInstance();
                    calendar.setTime(planoParcelado.getData1parcela());
                    String dataFormatada = simpleDateFormat.format(calendar.getTime());
                    String valorFormatado = valor1Parcela.movePointRight(2).toString();
                    bit62Formatado.append(StringUtil.completaString(valorFormatado + dataFormatada, 20, '0', 3));
                    for (int i = 0; i < numeroParcelas - 1; ++i) {
                        calendar.add(5, 30);
                        dataFormatada = simpleDateFormat.format(calendar.getTime());
                        valorFormatado = valorParcela.movePointRight(2).toString();
                        bit62Formatado.append(StringUtil.completaString(valorFormatado + dataFormatada, 20, '0', 3));
                    }
                    entradaApiTefC.setAdicionais(bit62Formatado.toString());
                    this.logger.debug((Object)("initEntradaApiTefC:valor das parcelas:plano parcelado=" + bit62Formatado.toString()));
                }
            } else if (plano instanceof PlanoPreDatado) {
                PlanoPreDatado planoPreDatado = (PlanoPreDatado)plano;
                if (planoPreDatado.getDataAgendamento() != null) {
                    String dataFormatada = new SimpleDateFormat("yyyyMMdd").format(planoPreDatado.getDataAgendamento());
                    String valorFormatado = valorTransacao.movePointRight(2).toString();
                    String bit62Formatado = StringUtil.completaString(valorFormatado + dataFormatada, 20, '0', 3);
                    entradaApiTefC.setAdicionais(bit62Formatado);
                    entradaApiTefC.setDataVencimento(planoPreDatado.getDataAgendamento());
                }
                if (planoPreDatado.getTipoGarantia() != -1) {
                    entradaApiTefC.setTipoGarantia(planoPreDatado.getTipoGarantia());
                    this.logger.debug((Object)("initEntradaApiTefC:tipo garantia:plano pre-datado=" + planoPreDatado.getTipoGarantia()));
                }
            } else if (plano instanceof PlanoAVista) {
                PlanoAVista planoAVista = (PlanoAVista)plano;
                if (planoAVista.getValorSaque() != null) {
                    entradaApiTefC.setValorCashBack(planoAVista.getValorSaque());
                    this.logger.debug((Object)("initEntradaApiTefC:valor do saque:plano avista=" + planoAVista.getValorSaque()));
                }
                entradaApiTefC.setNumeroParcelas(1);
                this.logger.debug((Object)"initEntradaApiTefC:n\u00famero de parcelas:plano avista=1");
            } else if (plano instanceof PlanoAPrazo) {
                BigDecimal valorEntrada;
                PlanoAPrazo prazo = (PlanoAPrazo)plano;
                entradaApiTefC.setNumeroParcelas(prazo.getNumeroParcela());
                this.logger.debug((Object)("initEntradaApiTefC:n\u00famero de parcelas=" + prazo.getNumeroParcela()));
                if (plano instanceof PlanoAdministradoraIATA && (valorEntrada = ((PlanoAdministradoraIATA)plano).getValorEntrada()) != null) {
                    entradaApiTefC.setValorEntrada(valorEntrada);
                    this.logger.debug((Object)("initEntradaApiTefC:valor da entrada=" + valorEntrada));
                }
            }
        }
        if (dados instanceof INumeroCupom) {
            INumeroCupom dadosNumetoCupom = (INumeroCupom)((Object)dados);
            entradaApiTefC.setNumeroCupom(dadosNumetoCupom.getNumeroCupom());
            this.logger.debug((Object)("initEntradaApiTefC:n\u00famero cupom=" + dadosNumetoCupom.getNumeroCupom()));
        }
        if (dados instanceof ICapturaNumeroPremios) {
            ICapturaNumeroPremios dadosPremios = (ICapturaNumeroPremios)((Object)dados);
            if (dadosPremios.getPremio() != null) {
                entradaApiTefC.setCodigoPremio(dadosPremios.getPremio().getCodigo());
                this.logger.debug((Object)("initEntradaApiTefC:c\u00f3digo pr\u00eamio=" + dadosPremios.getPremio().getCodigo()));
                entradaApiTefC.setDescricaoPremio(dadosPremios.getPremio().getDescricao());
                this.logger.debug((Object)("initEntradaApiTefC:descri\u00e7\u00e3o do pr\u00eamios=" + dadosPremios.getPremio().getDescricao()));
                entradaApiTefC.setQuantidadePremios(dadosPremios.getNumeroPremios());
                this.logger.debug((Object)("initEntradaApiTefC:n\u00famero de pr\u00eamios=" + dadosPremios.getNumeroPremios()));
            } else {
                this.logger.debug((Object)"initEntradaApiTefC:c\u00f3digo pr\u00eamio=null, ele n\u00e3o ser\u00e1 atribuido");
            }
        }
        if (dados instanceof INsuTransacao && (dadosNsu = (INsuTransacao)((Object)dados)).getNsuTransacao() > 0) {
            entradaApiTefC.setNsuCtfTransacaoOriginal(dadosNsu.getNsuTransacao());
            this.logger.debug((Object)("initEntradaApiTefC:NSU da transa\u00e7\u00e3o=" + dadosNsu.getNsuTransacao()));
        }
        if (dados instanceof ICertificadoDUKPT) {
            ICertificadoDUKPT dadosCertificadoDUKPT = (ICertificadoDUKPT)((Object)dados);
            entradaApiTefC.setIdentificadorChaveRSA(dadosCertificadoDUKPT.getIdentificadorChaveRSA());
            this.logger.debug((Object)("initEntradaApiTefC:identificador identificador chave RSA=" + dadosCertificadoDUKPT.getIdentificadorChaveRSA()));
            entradaApiTefC.setCertificadoCriptografico(dadosCertificadoDUKPT.getCertificadoCriptografico());
            this.logger.debug((Object)"initEntradaApiTefC:certificado criptografico= ****** ");
        }
    }

    protected SaidaApiTefC solicitaTEF(EntradaApiTefC entradaApiTefC, Process dados) throws ExcecaoApiAc {
        if (dados instanceof ISaidaApiTef || dados instanceof Process) {
            ISaidaApiTef dadosSaidaApiTef;
            ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
            Apitef apitef = dados.getApitef();
            EntradaCTFClientCtrl entradaIntegracao = null;
            IdentTerminal identTerminal = null;
            boolean multiTerminal = false;
            boolean delivery = false;
            if (dados instanceof IIntegracao) {
                IIntegracao dadosIntegracao = (IIntegracao)((Object)dados);
                if (dadosIntegracao.getEntradaIntegracao() != null) {
                    entradaIntegracao = dadosIntegracao.getEntradaIntegracao();
                    multiTerminal = entradaIntegracao.isMultiTerminal();
                    delivery = entradaIntegracao.getCodigoOrigemTransacao() == 1;
                } else if (dados instanceof IOrigemTransacao) {
                    IOrigemTransacao origemTransacao = (IOrigemTransacao)((Object)dados);
                    entradaApiTefC.setIdentificacaoTransacao(origemTransacao.getCodigoOrigemTransacao());
                }
                this.logger.debug((Object)("initEntradaApiTefC:multiterminal=" + multiTerminal));
                this.logger.debug((Object)("initEntradaApiTefC:delivery=" + delivery));
                if (multiTerminal || delivery) {
                    if (entradaIntegracao != null) {
                        identTerminal = entradaIntegracao.getIdentTerminal();
                    } else if (dados instanceof IIdentTerminal) {
                        identTerminal = ((IIdentTerminal)((Object)dados)).getIdentTerminal();
                    }
                    DadosInicioDia dadosInicioDia = ControladorInicioDia.getInstance().getDadosInicioDia(identTerminal, conf.getVersaoPathTerminal());
                    entradaApiTefC.setDataCliente(dadosInicioDia.getDataInicioDia());
                    this.logger.debug((Object)("initEntradaApiTefC:data cliente:inicioDia=" + dadosInicioDia.getDataInicioDia()));
                } else {
                    Date dataAbertura = dadosIntegracao.getEntradaIntegracao() != null ? dadosIntegracao.getEntradaIntegracao().getDataAbertura() : dados.getStartProcess();
                    identTerminal = new IdentTerminal(conf.getEstabelecimento(), conf.getLoja(), conf.getTerminal());
                    entradaApiTefC.setDataCliente(dataAbertura);
                    this.logger.debug((Object)("initEntradaApiTefC:data cliente:integra\u00e7\u00e3o=" + dataAbertura));
                }
            }
            if (dados instanceof IProcess) {
                Process dadosProcess = dados;
                if (entradaIntegracao == null) {
                    entradaApiTefC.setDataCliente(dadosProcess.getStartProcess());
                    this.logger.debug((Object)("initEntradaApiTefC:data cliente:corrente=" + dadosProcess.getStartProcess()));
                }
            }
            IdentApiTefC ident = new IdentApiTefC();
            ident.setNumeroEstabelecimento(identTerminal.getEstabelecimento());
            ident.setNumeroLoja(identTerminal.getLoja());
            ident.setNumeroPdv(identTerminal.getTerminal());
            ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
            ident.setListaIP(conf.getIps());
            ident.setQuantidadeVias(conf.getQuantidadeVias());
            SaidaApiTefC saidaApiTefC = apitef.solicitacao(ident, entradaApiTefC);
            if (dados instanceof ISaidaApiTef && (dadosSaidaApiTef = (ISaidaApiTef)((Object)dados)).getSaidaApiTef() != null && !dadosSaidaApiTef.getSaidaApiTef().isReenvioNegadaHost()) {
                ((ISaidaApiTef)((Object)dados)).setSaidaApiTef(saidaApiTefC);
                if (dados instanceof IEntradaApiTef) {
                    ((IEntradaApiTef)((Object)dados)).setEntradaApiTef(entradaApiTefC);
                }
            }
            return saidaApiTefC;
        }
        throw new ExcecaoApiAc("process invalido. n\u00e3o \u00e9 poss\u00edvel realizar transa\u00e7\u00e3o com o CTF.");
    }

    protected void montaDisplay(Process dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (dados instanceof IDevices) {
            ISaidaApiTef dadosSaidaApiTef;
            if (dados instanceof ISaidaApiTef && (dadosSaidaApiTef = (ISaidaApiTef)((Object)dados)).getSaidaApiTef() != null && !dadosSaidaApiTef.getSaidaApiTef().isReenvioNegadaHost()) {
                ControladorPerifericos perifericos = dados.getPerifericos();
                LayoutDisplay display = new LayoutDisplay();
                display.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO1")));
                display.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO2")));
                display.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO3")));
                perifericos.imprimeDisplay(display);
            }
        } else {
            throw new IllegalArgumentException("n\u00e3o foi poss\u00edvel montar display. process n\u00e3o implementa IDevices");
        }
    }

    protected String testaRetorno(SaidaApiTefC saidaApiTefC, Process dados) {
        if (saidaApiTefC != null) {
            if (saidaApiTefC.getRetorno() != 0) {
                this.logger.log((Priority)Level.INFO, (Object)("Resposta autorizadora: " + saidaApiTefC.getCodigoRespostaAutorizadora()));
                return ERRO;
            }
            if (dados instanceof IDadosRetorno1F) {
                VerifyContentUtil.preencheDadosSaida((IDadosRetorno1F)((Object)dados), saidaApiTefC);
            }
            return SUCESS;
        }
        return ERRO;
    }
}

