/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.autenticacao.AutenticacaoUtil;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IAutenticacao;
import com.csi.ctfclient.operacoes.microoperacoes.MicAutenticacaoJava1_4Compatible;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.log4j.Logger;

public class MicAutenticacao
extends MicAutenticacaoJava1_4Compatible {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String USER_CANCEL_INTERNAL = "USER_CANCEL_INTERNAL";
    public static final String ERROR_AC = "ERROR_AC";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(IAutenticacao dados) throws Exception {
        ConfCTFClient confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
        if (!confCTFClient.isSuporteHttps()) {
            return SUCCESS;
        }
        AutenticacaoUtil autenticacaoUtil = AutenticacaoUtil.getInstance();
        if (autenticacaoUtil.isTokenAutorizacao()) {
            return SUCCESS;
        }
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dados.getPerifericos();
        String login = null;
        String password = null;
        String cnpj = null;
        for (int step = 1; step < 4; ++step) {
            EventoTeclado eventoTeclado = null;
            LayoutDisplay layoutDisplay = null;
            if (step == 1) {
                layoutDisplay = new LayoutDisplay();
                layoutDisplay.addLinha(new Linha(inter.getMessage("CAPAUTENTICADOR_TITLE")));
                layoutDisplay.addLinha(new Linha(inter.getMessage("CAPAUTENTICADOR_LOGIN"), 0, 1));
                eventoTeclado = (EventoTeclado)perifericos.capturaDado(layoutDisplay, ConstantesApiAc.CAP_AUT_LOGIN, 0, true, 0, false, false);
                login = eventoTeclado.getStringLida().substring(0, eventoTeclado.getNumCaracteresDigitados());
            } else if (step == 2) {
                layoutDisplay = new LayoutDisplay();
                layoutDisplay.addLinha(new Linha(inter.getMessage("CAPAUTENTICADOR_TITLE")));
                layoutDisplay.addLinha(new Linha(inter.getMessage("CAPAUTENTICADOR_PASSWORD"), 0, 1));
                eventoTeclado = (EventoTeclado)perifericos.capturaDado(layoutDisplay, ConstantesApiAc.CAP_AUT_PASSWORD, 0, true, 0, false, true);
                password = eventoTeclado.getStringLida().substring(0, eventoTeclado.getNumCaracteresDigitados());
            } else if (step == 3) {
                layoutDisplay = new LayoutDisplay();
                layoutDisplay.addLinha(new Linha(inter.getMessage("CAPAUTENTICADOR_TITLE")));
                layoutDisplay.addLinha(new Linha(inter.getMessage("CAPAUTENTICADOR_CNPJ"), 0, 1));
                eventoTeclado = (EventoTeclado)perifericos.capturaDado(layoutDisplay, ConstantesApiAc.CAP_AUT_CNPJ, 0, true, 0, false, false);
                cnpj = eventoTeclado.getStringLida().substring(0, eventoTeclado.getNumCaracteresDigitados());
            }
            if (!"VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) continue;
            return USER_CANCEL;
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("login", login.toLowerCase());
        parameters.put("senha", password.toLowerCase());
        parameters.put("cnpj", cnpj);
        if (this.isWin()) {
            parameters.put("tipo", "5");
        } else {
            parameters.put("tipo", "6");
        }
        parameters.put("suporteHttps", "true");
        parameters.put("tipoidentificacao", "3");
        parameters.put("identificacao", this.getMAC());
        parameters.put("fabricante", this.getOSName());
        parameters.put("modelo", this.getOSVersion());
        LayoutDisplay displayModel = new LayoutDisplay("AGUARDE...");
        perifericos.imprimeDisplay(displayModel);
        return this.processaResposta(dados, cnpj, parameters);
    }

    private boolean isWin() {
        String osName = this.getOSName();
        return osName.indexOf("win") >= 0;
    }

    private String getOSName() {
        return System.getProperty("os.name").toLowerCase();
    }

    private String getOSVersion() {
        return System.getProperty("os.version") + " - " + System.getProperty("os.arch");
    }

    private String getMAC() {
        String mac = null;
        try {
            InetAddress ip = InetAddress.getLocalHost();
            mac = ip.getHostName();
        }
        catch (UnknownHostException e) {
            this.logger.error((Object)"nao foi possivel recuperar o MAC", (Throwable)e);
        }
        return mac;
    }

    public static void main(String[] args) {
        System.out.println(System.getProperty("os.name"));
        System.out.println(System.getProperty("os.arch"));
        System.out.println(System.getProperty("os.version"));
        System.out.println(System.getProperty("sun.os.patch.level"));
        Properties p = System.getProperties();
        p.list(System.out);
    }
}

