/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.ICaputura4UltimosDigitos;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCaptura4UltimodigitoCartao {
    public static final String SUCESS = "SUCESS";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String ERRO_NOT_VALID = "ERRO_NOT_VALID";
    public static final String ERRO_NOT_VALID_AC = "ERRO_NOT_VALID_AC";

    public String execute(ICaputura4UltimosDigitos dado) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (dado.getCartao() == null) {
            throw new IllegalArgumentException("Cartao n\u00e3o informado");
        }
        if (!dado.getSaidaApiTef().isPede4Digitos()) {
            return UNECESSARY;
        }
        if (dado.isQuatroUltimosDigCapturados()) {
            return UNECESSARY;
        }
        if (dado.getEntradaIntegracao() != null) {
            if (dado.getEntradaIntegracao().isMultiTerminal()) {
                return SUCESS;
            }
            if (dado.getEntradaIntegracao().isMultiTerminal()) {
                dado.setErroIntegracao(new CodigoErroIntegracao(5303, inter.getMessage("CAP4ULTDIG_ERRO_NOT_VALID")));
                return ERRO_NOT_VALID_AC;
            }
        }
        ControladorPerifericos perifericos = dado.getPerifericos();
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(inter.getMessage("CAP4ULTDIG_TITLE1")));
        displayModel.addLinha(new Linha(inter.getMessage("CAP4ULTDIG_TITLE2")));
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_4ULTIMOS_DIGITOS, false, 12, true);
        if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
            return USERCANCEL;
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        String digitos = eventoTeclado.getStringLida().substring(num);
        if (!this.isvalid4UltimoDigito(dado.getCartao().getNumero(), digitos)) {
            this.exibeMensagem(perifericos, inter.getMessage("CAP4ULTDIG_ERRO_NOT_VALID"));
            dado.setCartao(null);
            return ERRO_NOT_VALID;
        }
        if (dado.getEntradaIntegracao() != null && dado.getEntradaIntegracao().isConsulta()) {
            dado.setQuatroUltimosDigCapturados(true);
        }
        return SUCESS;
    }

    private boolean isvalid4UltimoDigito(String numero, String ultimos4digitos) {
        int tamanho = numero.length();
        return ultimos4digitos.equals(numero.substring(tamanho - 4, tamanho));
    }

    private void exibeMensagem(ControladorPerifericos perifericos, String messagem) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(messagem);
        perifericos.confirmaDado(displayModel);
    }
}

