/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.INsuAutorizacao;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaAutorizacaoCancelamento {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String INVALID_CODIGO = "INVALID_CODIGO";

    public String execute(INsuAutorizacao dado) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (dado.getNsuAutorizacao() != null) {
            return FILLED;
        }
        ControladorPerifericos perifericos = dado.getPerifericos();
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel = new LayoutDisplay(inter.getMessage("CAPAUTCAN_TITLE")), ConstantesApiAc.CAP_CODIGO_APROVACAO, true, 7, true);
        if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
            return USER_CANCEL;
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        String codigoAutorizacao = eventoTeclado.getStringLida().substring(num);
        if (codigoAutorizacao.equals("")) {
            return INVALID_CODIGO;
        }
        dado.setNsuAutorizacao(codigoAutorizacao);
        return SUCESS;
    }
}

