/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IBanco;
import com.csi.ctfclient.operacoes.model.Cmc7;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaBanco {
    public static final String SUCESS = "SUCESS";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String FILLED = "FILLED";

    public String execute(IBanco dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (dados.getBanco() > 0) {
            return FILLED;
        }
        if (dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isBancoCtrl()) {
            dados.setBanco(dados.getEntradaIntegracao().getBanco());
            return SUCESS;
        }
        if (dados.getCmc7() != null) {
            Cmc7 cmc7 = new Cmc7(dados.getCmc7());
            dados.setBanco(Integer.parseInt(cmc7.getBanco()));
            return SUCESS;
        }
        ControladorPerifericos periferico = dados.getPerifericos();
        String valor = null;
        int caracteresDigitados = 0;
        while (caracteresDigitados < 1) {
            LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("CAPBAN_TITLE"));
            EventoTeclado eventoTeclado = (EventoTeclado)periferico.capturaDado(displayModel, ConstantesApiAc.CAP_NUMERO_BANCO);
            if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                return USER_CANCEL;
            }
            caracteresDigitados = eventoTeclado.getNumCaracteresDigitados();
            int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
            valor = eventoTeclado.getStringLida().substring(num).trim();
        }
        dados.setBanco(Integer.parseInt(valor));
        return SUCESS;
    }
}

