/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.ICapturaCartaoPrepago;
import com.csi.ctfclient.operacoes.model.CMOSPinPad;
import com.csi.ctfclient.operacoes.model.CartaoMagnetico;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.PerifericoEventHandler;
import com.csi.ctfclient.tools.devices.DadosLeitorCartao;
import com.csi.ctfclient.tools.devices.EventoDispositivoEntrada;
import com.csi.ctfclient.tools.devices.EventoLeitorDocumento;
import com.csi.ctfclient.tools.devices.EventoScanner;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.ILeitorCartaoHandler;
import com.csi.ctfclient.tools.devices.LeitorDocumento;
import com.csi.ctfclient.tools.devices.Scanner;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emv.EventoLeitorCartaoEMV;
import com.csi.ctfclient.tools.devices.emv.LeitorCartaoEMV;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.util.Date;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicCapturaCartaoPrepago {
    public static final String SUCCESS = "SUCCESS";
    public static final String FILLED = "FILLED";
    public static final String ERROR = "ERROR";
    public static final String ERROR_AC = "ERROR_AC";
    public static final String USER_CANCEL = "USER_CANCEL";
    private static final String MST_ERRO_READ_CARD1 = "ERRO DE LEITURA";
    private static final String MST_ERRO_READ_CARD2 = "TENTE NOVAMENTE";
    private Logger logger = CTFClientLogger.getPeriferico();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String execute(ICapturaCartaoPrepago dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (dados.getCodigoBarrasCartaoPrepago() != null || dados.getCartao() != null) {
            return FILLED;
        }
        if (dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isCodigoBarrasCtrl() && dados.getEntradaIntegracao().isModoEntradaCodigoBarrasCtrl()) {
            if (dados.getEntradaIntegracao().getCodigoBarras().length() >= 30) {
                int modoEntrada = dados.getEntradaIntegracao().getModoEntradaCodigoBarras();
                dados.setCodigoBarrasCartaoPrepago(dados.getEntradaIntegracao().getCodigoBarras().trim());
                dados.setModoEntradaCodigoBarrasCartaoPrepago(modoEntrada);
                return SUCCESS;
            }
            this.logger.log((Priority)Level.ERROR, (Object)"O c\u00f3digo de barras possui menos de 30 d\u00edgitos");
            dados.setErroIntegracao(new CodigoErroIntegracao(5399, "CODIGO DE BARRAS INVALIDO"));
            return ERROR_AC;
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        String tituloDisplay = inter.getMessage("CAPCODBARCATPRE_TITLE");
        long[] entradaDados = new long[]{1L, 2L, 16L};
        boolean habilitaCartao = dados.getEntradaIntegracao().getOperacao() != 275 && dados.getEntradaIntegracao().getOperacao() != 276;
        Scanner scanner = null;
        try {
            scanner = perifericos.getScanner();
            if (scanner != null) {
                scanner.habilita();
            }
        }
        catch (ExcecaoPerifericos e) {
            this.logger.info((Object)"Scanner n\u00e3o conectado");
        }
        LeitorDocumento leitorDocumento = perifericos.getLeitorDocumento();
        try {
            if (leitorDocumento != null) {
                leitorDocumento.habilita();
            }
        }
        catch (ExcecaoPerifericos e) {
            this.logger.info((Object)"Leitor de documentos n\u00e3o conectado");
        }
        ILeitorCartaoHandler cartaoHandler = null;
        if (habilitaCartao) {
            try {
                if (perifericos.getLeitorCartao() != null) {
                    cartaoHandler = perifericos.getLeitorCartao();
                    LeitorCartaoEMV leitorEMV = (LeitorCartaoEMV)cartaoHandler.getLeitorCartao();
                    leitorEMV.setIdRedeAdquirente(leitorEMV.getIdRedeAdquirente());
                    DadosLeitorCartao dadosLeitorCartao = (DadosLeitorCartao)((Object)cartaoHandler.getLeitorCartao());
                    dadosLeitorCartao.setTipoAplicacao(99);
                    CMOSPinPad cmosPinPad = CMOSPinPad.getInstance();
                    dadosLeitorCartao.setTimeStamp(cmosPinPad.getTimeStamp(0));
                    dadosLeitorCartao.setDataTransacao(new Date());
                    try {
                        cmosPinPad = CMOSPinPad.getInstance();
                        PerifericoEventHandler.setActive(true);
                        cartaoHandler.habilitaTrilha(1);
                        cartaoHandler.habilitaTrilha(2);
                        cartaoHandler.habilita();
                        tituloDisplay = inter.getMessage("CAPCARTPRE_TITLE");
                        entradaDados = new long[]{1L, 2L, 16L, 8L};
                    }
                    catch (Exception e) {
                        perifericos.liberarRecursosPinCartao();
                    }
                }
            }
            catch (ExcecaoPerifericos e) {
                this.logger.info((Object)"Leitor de cartao n\u00e3o conectado");
            }
        }
        LayoutDisplay displayTitulo = null;
        ConstantesApiAc.TipoCampo mascaraEdicao = null;
        displayTitulo = new LayoutDisplay(tituloDisplay);
        mascaraEdicao = ConstantesApiAc.CAP_CODIGO_BARRAS_CARTAO_PREPAGO_BLACKHAWK;
        PerifericoEventHandler.setActive(true);
        EventoDispositivoEntrada evento = perifericos.capturaDado(displayTitulo, mascaraEdicao, true, "", entradaDados);
        if (evento instanceof EventoTeclado) {
            EventoTeclado eventoTeclado = (EventoTeclado)evento;
            if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
                try {
                    if (scanner != null) {
                        scanner.desabilita();
                    }
                }
                catch (ExcecaoPerifericos e) {
                    // empty catch block
                }
                try {
                    if (leitorDocumento != null) {
                        leitorDocumento.desabilita();
                    }
                }
                catch (ExcecaoPerifericos e) {
                    // empty catch block
                }
                try {
                    if (cartaoHandler == null) return USER_CANCEL;
                    cartaoHandler.desabilita();
                    return USER_CANCEL;
                }
                catch (ExcecaoPerifericos e) {
                    // empty catch block
                }
                return USER_CANCEL;
            }
            int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
            String codigoBarras = eventoTeclado.getStringLida().substring(num);
            if (codigoBarras.length() == 0) {
                LayoutDisplay displayError = new LayoutDisplay(inter.getMessage("CAPCODBARCATPRE_ERRO_TAMANHO_MINIMO"));
                perifericos.confirmaDado(displayError);
                return ERROR;
            }
            dados.setModoEntradaCodigoBarrasCartaoPrepago(1);
            dados.setCodigoBarrasCartaoPrepago(codigoBarras);
        } else if (evento instanceof EventoScanner || evento instanceof EventoLeitorDocumento) {
            String codigoBarras = "";
            int meioCaptura = 0;
            if (evento instanceof EventoScanner) {
                EventoScanner eventoScanner = (EventoScanner)evento;
                codigoBarras = eventoScanner.getRepresentacaoString();
                meioCaptura = 3;
            } else if (evento instanceof EventoLeitorDocumento) {
                EventoLeitorDocumento eventoLeitorDocumento = (EventoLeitorDocumento)evento;
                codigoBarras = eventoLeitorDocumento.getRepresentacaoString();
                meioCaptura = 3;
            }
            if (codigoBarras.length() == 0) {
                LayoutDisplay displayError = new LayoutDisplay(inter.getMessage("CAPCODBARCATPRE_ERRO_TAMANHO_MINIMO"));
                perifericos.confirmaDado(displayError);
                return ERROR;
            }
            dados.setCodigoBarrasCartaoPrepago(codigoBarras);
            dados.setModoEntradaCodigoBarrasCartaoPrepago(meioCaptura);
        } else {
            if (!(evento instanceof EventoLeitorCartaoEMV)) throw new IllegalArgumentException("Tipo de evento n\u00e3o esperado");
            EventoLeitorCartaoEMV eventoEMV = (EventoLeitorCartaoEMV)evento;
            System.out.println(eventoEMV.getErroCodigo());
            switch (eventoEMV.getErroCodigo()) {
                case 13: {
                    return USER_CANCEL;
                }
            }
            if (eventoEMV.getErroCodigo() != 0) {
                this.exibeMensagemDuasLinhas(perifericos, MST_ERRO_READ_CARD1, MST_ERRO_READ_CARD2);
                return ERROR;
            }
            if (eventoEMV.getTipoCartao() == 0) {
                CartaoMagnetico cartao = new CartaoMagnetico(eventoEMV.getTrilha1(), eventoEMV.getTrilha2(), eventoEMV.getNomePortadorCartao(), eventoEMV.getNumeroExternoCartao(), eventoEMV.getPAN(), eventoEMV.getPANCripto(), eventoEMV.getPANTrilha1(), eventoEMV.getPANTrilha2(), eventoEMV.getTipoAplicacaoSelecionada(), eventoEMV.getStatusUltLeitura(), eventoEMV.getTipoCartao(), eventoEMV.getIssuerCountryCode(), eventoEMV.getFlags(), eventoEMV.getPix(), eventoEMV.getIdCred(), eventoEMV.getDadosRestantes());
                dados.setCartao(cartao);
            } else {
                this.exibeMensagemDuasLinhas(perifericos, inter.getMessage("CAPCODBARCATPRE_ERRO_TARJA"), "");
                return ERROR;
            }
        }
        try {
            if (scanner != null) {
                scanner.desabilita();
            }
        }
        catch (ExcecaoPerifericos e) {
            // empty catch block
        }
        try {
            if (cartaoHandler != null) {
                cartaoHandler.desabilita();
            }
        }
        catch (ExcecaoPerifericos e) {
            // empty catch block
        }
        PerifericoEventHandler.setActive(false);
        return SUCCESS;
    }

    private void exibeMensagemDuasLinhas(ControladorPerifericos perifericos, String msg1, String msg2) throws ExcecaoApiAc {
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.setDelay(1500L);
        displayModel.addLinha(new Linha(msg1));
        displayModel.addLinha(new Linha(msg2));
        perifericos.imprimeDisplay(displayModel);
    }
}

