/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.ICapturaCmc7;
import com.csi.ctfclient.operacoes.model.PerifericoEventHandler;
import com.csi.ctfclient.tools.devices.EventoDispositivoEntrada;
import com.csi.ctfclient.tools.devices.EventoLeitorDocumento;
import com.csi.ctfclient.tools.devices.EventoScanner;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.LeitorDocumento;
import com.csi.ctfclient.tools.devices.Scanner;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import org.apache.log4j.Logger;

public class MicCapturaCmc7 {
    public static final String SUCESS = "SUCESS";
    public static final String UNNECESSARY = "UNNECESSARY";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";
    private Logger logger = CTFClientLogger.getPeriferico();
    private Scanner scanner;

    public String execute(ICapturaCmc7 dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        boolean capturaCmc7 = ControladorConfCTFClient.getInstance().getConfig().isCapturaCmc7();
        if (!capturaCmc7) {
            return UNNECESSARY;
        }
        if (dados.getCmc7() != null) {
            return FILLED;
        }
        if (dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isCmc7Ctrl()) {
            dados.setCmc7(dados.getEntradaIntegracao().getCmc7());
            return SUCESS;
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        try {
            this.scanner = perifericos.getScanner();
            if (this.scanner != null) {
                this.scanner.habilita();
            }
        }
        catch (ExcecaoPerifericos e) {
            this.logger.info((Object)"Scanner n\u00e3o conectado");
        }
        LeitorDocumento leitorDocumento = perifericos.getLeitorDocumento();
        try {
            if (leitorDocumento != null) {
                leitorDocumento.habilita();
            }
        }
        catch (ExcecaoPerifericos e) {
            this.logger.info((Object)"Leitor de documentos n\u00e3o conectado");
        }
        String digitos = "";
        while (digitos.trim().length() != 30 && digitos.trim().length() != 34) {
            LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("CAPCMC7_TITLE"));
            long[] entradaDados = new long[]{1L, 16L, 2L};
            PerifericoEventHandler.setActive(true);
            EventoDispositivoEntrada evento = perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_CMC7, true, digitos, entradaDados);
            if (evento instanceof EventoTeclado) {
                EventoTeclado eventoTeclado = (EventoTeclado)evento;
                if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
                    return USER_CANCEL;
                }
                int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
                digitos = eventoTeclado.getStringLida().substring(num);
                continue;
            }
            if (evento instanceof EventoLeitorDocumento) {
                EventoLeitorDocumento eventoLeitorDocumento = (EventoLeitorDocumento)evento;
                digitos = eventoLeitorDocumento.getCodigo();
                this.logger.debug((Object)"Documento lido pelo leitor de documentos");
                continue;
            }
            if (evento instanceof EventoScanner) {
                EventoScanner eventoScanner = (EventoScanner)evento;
                digitos = eventoScanner.getRepresentacaoString();
                continue;
            }
            throw new IllegalArgumentException("Tipo de evento n\u00e3o esperado");
        }
        dados.setCmc7(digitos);
        return SUCESS;
    }
}

