/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDadosCnpj;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.CnpjUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaCnpj {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String INVALID_CNPJ = "INVALID_CNPJ";
    public static final String INVALID_CNPJ_AC = "INVALID_CNPJ_AC";

    public String execute(IDadosCnpj dados) throws ExcecaoNaoLocal {
        EventoTeclado eventoTeclado;
        LayoutDisplay displayModel;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (dados.getCnpj() != null) {
            return FILLED;
        }
        if (dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isDocumentoCtrl() && dados.getEntradaIntegracao().isTipoDocumentoCtrl() && dados.getEntradaIntegracao().getTipoDocumento() == 1) {
            String cnpj = dados.getEntradaIntegracao().getDocumento();
            if (CnpjUtil.validaCnpj(cnpj)) {
                dados.setCnpj(cnpj);
                return SUCESS;
            }
            dados.setErroIntegracao(new CodigoErroIntegracao(5318, inter.getMessage("CAPCNP_INVALID_CNPJ")));
            return INVALID_CNPJ_AC;
        }
        ControladorPerifericos periferico = dados.getPerifericos();
        String valor = null;
        int caracteresDigitados = 0;
        while (caracteresDigitados != 14) {
            displayModel = new LayoutDisplay(inter.getMessage("CAPCNP_TITLE"));
            eventoTeclado = (EventoTeclado)periferico.capturaDado(displayModel, ConstantesApiAc.CAP_CNPJ);
            if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                return USER_CANCEL;
            }
            caracteresDigitados = eventoTeclado.getNumCaracteresDigitados();
            int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
            valor = eventoTeclado.getStringLida().substring(num);
        }
        if (CnpjUtil.validaCnpj(valor)) {
            dados.setCnpj(valor);
            return SUCESS;
        }
        displayModel = new LayoutDisplay(inter.getMessage("CAPCNP_INVALID_CNPJ"));
        eventoTeclado = (EventoTeclado)periferico.confirmaDado(displayModel);
        if (eventoTeclado.getTeclaFinalizadora().equals("ENTRA")) {
            return INVALID_CNPJ;
        }
        return USER_CANCEL;
    }
}

