/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.ICapturaCodigoBarrasPagamento;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.PerifericoEventHandler;
import com.csi.ctfclient.tools.devices.EventoDispositivoEntrada;
import com.csi.ctfclient.tools.devices.EventoLeitorDocumento;
import com.csi.ctfclient.tools.devices.EventoScanner;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.LeitorDocumento;
import com.csi.ctfclient.tools.devices.Scanner;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import org.apache.log4j.Logger;

public class MicCapturaCodigoBarras {
    public static final String SUCESS = "SUCESS";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String FILLED = "FILLED";
    public static final String ERROR_AC = "ERROR_AC";
    private Logger logger = CTFClientLogger.getPeriferico();
    private Scanner scanner;

    public String execute(ICapturaCodigoBarrasPagamento dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorConfCTFClient confCTFClient = ControladorConfCTFClient.getInstance();
        if (dados.getCodigoBarras() != null) {
            return FILLED;
        }
        if (dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isCodigoBarrasCtrl() && dados.getEntradaIntegracao().isModoEntradaCodigoBarrasCtrl()) {
            int modoEntrada = dados.getEntradaIntegracao().getModoEntradaCodigoBarras();
            if (modoEntrada != 1 && modoEntrada != 3 && modoEntrada != 3) {
                dados.setErroIntegracao(new CodigoErroIntegracao(5360, "MODO DE ENTRADA INVALIDO"));
                return ERROR_AC;
            }
            dados.setCodigoBarras(dados.getEntradaIntegracao().getCodigoBarras());
            dados.setModoEntradaCodigoBarras(dados.getEntradaIntegracao().getModoEntradaCodigoBarras());
            return SUCESS;
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        int numeroBloco = dados.getNumeroBloco();
        try {
            if (numeroBloco == 1) {
                this.scanner = perifericos.getScanner();
                if (this.scanner != null) {
                    this.scanner.habilita();
                }
            }
        }
        catch (ExcecaoPerifericos e) {
            this.logger.info((Object)"Scanner n\u00e3o conectado");
        }
        LeitorDocumento leitorDocumento = perifericos.getLeitorDocumento();
        try {
            if (leitorDocumento != null) {
                leitorDocumento.habilita();
            }
        }
        catch (ExcecaoPerifericos e) {
            this.logger.info((Object)"Leitor de documentos n\u00e3o conectado");
        }
        String digitos = null;
        boolean continuaCaptura = true;
        String digitosParcial = "";
        while (continuaCaptura) {
            LayoutDisplay displayModel = null;
            ConstantesApiAc.TipoCampo mascaraEdicao = null;
            int tamanhoMinimoExigido = 0;
            if (dados.getTipoConta() == 1) {
                if (numeroBloco == 1) {
                    displayModel = new LayoutDisplay(inter.getMessage("CAPCODBAR_TITLE") + numeroBloco);
                    mascaraEdicao = ConstantesApiAc.CAP_CODIGO_BARRAS_TITULO_BL1;
                    tamanhoMinimoExigido = 10;
                } else if (numeroBloco == 2) {
                    displayModel = new LayoutDisplay(inter.getMessage("CAPCODBAR_TITLE") + numeroBloco);
                    mascaraEdicao = ConstantesApiAc.CAP_CODIGO_BARRAS_TITULO_BL2;
                    tamanhoMinimoExigido = 11;
                } else if (numeroBloco == 3) {
                    displayModel = new LayoutDisplay(inter.getMessage("CAPCODBAR_TITLE") + numeroBloco);
                    mascaraEdicao = ConstantesApiAc.CAP_CODIGO_BARRAS_TITULO_BL3;
                    tamanhoMinimoExigido = 11;
                } else if (numeroBloco == 4) {
                    displayModel = new LayoutDisplay(inter.getMessage("CAPCODBAR_TITLE") + numeroBloco);
                    mascaraEdicao = ConstantesApiAc.CAP_CODIGO_BARRAS_TITULO_BL4;
                    tamanhoMinimoExigido = 1;
                } else if (numeroBloco == 5) {
                    displayModel = new LayoutDisplay(inter.getMessage("CAPCODBAR_TITLE") + numeroBloco);
                    mascaraEdicao = ConstantesApiAc.CAP_CODIGO_BARRAS_TITULO_BL5;
                }
            } else {
                displayModel = new LayoutDisplay(inter.getMessage("CAPCODBAR_TITLE") + numeroBloco);
                if (confCTFClient.getConfig().isCapturaApenasLinhaDigitavel() && numeroBloco == 1) {
                    mascaraEdicao = ConstantesApiAc.CAP_CODIGO_BARRAS;
                    tamanhoMinimoExigido = 10;
                    digitosParcial = "";
                } else {
                    mascaraEdicao = ConstantesApiAc.CAP_CODIGO_BARRAS;
                    if (numeroBloco == 1) {
                        mascaraEdicao = ConstantesApiAc.CAP_CODIGO_BARRAS_CONVENIO_BL1;
                    } else if (numeroBloco == 2) {
                        mascaraEdicao = ConstantesApiAc.CAP_CODIGO_BARRAS_CONVENIO_BL2;
                    } else if (numeroBloco == 3) {
                        mascaraEdicao = ConstantesApiAc.CAP_CODIGO_BARRAS_CONVENIO_BL3;
                    } else if (numeroBloco == 4) {
                        mascaraEdicao = ConstantesApiAc.CAP_CODIGO_BARRAS_CONVENIO_BL4;
                    }
                    if (numeroBloco > 1) {
                        tamanhoMinimoExigido = 12;
                    }
                }
            }
            digitosParcial = "";
            PerifericoEventHandler.setActive(true);
            EventoDispositivoEntrada evento = perifericos.capturaDado(displayModel, mascaraEdicao, true, digitosParcial, new long[]{1L, 2L, 16L});
            if (evento instanceof EventoTeclado) {
                EventoTeclado eventoTeclado = (EventoTeclado)evento;
                if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
                    try {
                        if (this.scanner != null) {
                            this.scanner.desabilita();
                        }
                    }
                    catch (ExcecaoPerifericos e) {
                        // empty catch block
                    }
                    return USER_CANCEL;
                }
                int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
                digitos = eventoTeclado.getStringLida().substring(num);
                if (tamanhoMinimoExigido != 0 && digitos.length() < tamanhoMinimoExigido) {
                    digitosParcial = digitos;
                    continuaCaptura = true;
                    continue;
                }
                if (digitos.length() <= 0) continue;
                continuaCaptura = false;
                dados.setModoEntradaCodigoBarras(1);
                continue;
            }
            if (evento instanceof EventoScanner) {
                EventoScanner eventoScanner = (EventoScanner)evento;
                digitos = eventoScanner.getRepresentacaoString();
                continuaCaptura = false;
                dados.setModoEntradaCodigoBarras(3);
                continue;
            }
            if (evento instanceof EventoLeitorDocumento) {
                EventoLeitorDocumento eventoLeitorDocumento = (EventoLeitorDocumento)evento;
                digitos = eventoLeitorDocumento.getCodigo();
                continuaCaptura = false;
                dados.setModoEntradaCodigoBarras(3);
                continue;
            }
            throw new IllegalArgumentException("Tipo de evento n\u00e3o esperado");
        }
        try {
            if (this.scanner != null) {
                this.scanner.desabilita();
            }
        }
        catch (ExcecaoPerifericos e) {
            // empty catch block
        }
        PerifericoEventHandler.setActive(false);
        if (dados.getModoEntradaCodigoBarras() == 3) {
            dados.setCodigoBarras(digitos);
        } else if (dados.getModoEntradaCodigoBarras() == 3) {
            dados.setCodigoBarras(digitos);
        } else if (dados.getModoEntradaCodigoBarras() == 1) {
            dados.setLinhaDigitavel(digitos);
        }
        return SUCESS;
    }
}

