/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.ICapturaCodigoCliente;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaCodigoCliente {
    public static final String SUCCESS = "SUCCESS";
    public static final String SUCCESS_BLANK = "SUCCESS_BLANK";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";

    public String execute(ICapturaCodigoCliente dados) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel;
        if (dados.getCodigoCliente() != 0) {
            return FILLED;
        }
        if (dados.getEntradaIntegracao() != null) {
            if (dados.getEntradaIntegracao().isCodigoClienteCtrl()) {
                dados.setCodigoCliente(dados.getEntradaIntegracao().getCodigoCliente());
                return SUCCESS;
            }
            if (dados.getEntradaIntegracao().isMultiTerminal()) {
                return SUCCESS_BLANK;
            }
        }
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        String valor = null;
        ControladorPerifericos periferico = dados.getPerifericos();
        EventoTeclado eventoTeclado = (EventoTeclado)periferico.capturaDado(displayModel = new LayoutDisplay(inter.getMessage("CAPCODCLI_TITLE")), ConstantesApiAc.CAP_CODIGO_CLIENTE);
        if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
            return USER_CANCEL;
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        valor = eventoTeclado.getStringLida().substring(num).trim();
        dados.setCodigoCliente(Integer.parseInt(valor));
        return SUCCESS;
    }
}

