/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.ICapturaCodigoPreAutorizacao;
import com.csi.ctfclient.operacoes.model.Cartao;
import com.csi.ctfclient.operacoes.model.CartaoDigitado;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaCodigoPreAutorizacao {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String INVALID_CODIGO = "INVALID_CODIGO";
    public static final String UNECESSARY = "UNECESSARY";

    public String execute(ICapturaCodigoPreAutorizacao dado) throws ExcecaoApiAc {
        LayoutDisplay displayModel;
        if (!this.isCapturaPreAutorizacao(dado)) {
            return SUCESS;
        }
        if (dado.getCodigoPreAutorizacao() != null) {
            return FILLED;
        }
        if (dado.getEntradaIntegracao() != null && dado.getEntradaIntegracao().isInfoAdicionaisCtrl()) {
            dado.setCodigoPreAutorizacao(dado.getEntradaIntegracao().getInfoAdicionais());
            return SUCESS;
        }
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dado.getPerifericos();
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel = new LayoutDisplay(inter.getMessage("CAPCODPREAUT_TITLE")), ConstantesApiAc.CAP_CODIGO_PRE_AUTORIZACAO, true, 7, true);
        if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
            return USER_CANCEL;
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        String codigoAutorizacao = eventoTeclado.getStringLida().substring(num);
        if (codigoAutorizacao.equals("")) {
            if (this.exibeMensagem(perifericos, inter.getMessage("CAPCODPREAUT_ERROR")).equals("ENTRA")) {
                return INVALID_CODIGO;
            }
            return USER_CANCEL;
        }
        dado.setCodigoPreAutorizacao(codigoAutorizacao);
        return SUCESS;
    }

    private String exibeMensagem(ControladorPerifericos perifericos, String msg) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(msg);
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.confirmaDado(displayModel);
        return eventoTeclado.getTeclaFinalizadora();
    }

    private boolean isCapturaPreAutorizacao(ICapturaCodigoPreAutorizacao dados) {
        if ("OPERACAO CONFIRMACAO PRE AUTORIZACAO".equals(dados.getTipoOperacao())) {
            return true;
        }
        if (dados.getSaidaApiTef() != null) {
            Cartao cartao = dados.getCartao();
            return cartao instanceof CartaoDigitado && dados.getSaidaApiTef().isCapturaPreAutorizacao();
        }
        return false;
    }
}

