/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.ICaputuraCodigoSeguranca;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.CodigoSeguranca;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaCodigoSeguranca {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String USERCANCEL_MOTIVO = "USERCANCEL_MOTIVO";
    public static final String INVALID_LENGTH = "INVALID_LENGTH";
    public static final String INVALID_LENGTH_AC = "INVALID_LENGTH_AC";
    public static final String ERRO_IS_REQUIRED = "ERRO_IS_REQUIRED";
    private static final String MSG_INVALID_COD_SEGURANCA = "COD. SEGURANCA INVALIDO";

    public String execute(ICaputuraCodigoSeguranca dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        SaidaApiTefC saida = dados.getSaidaApiTef();
        if (saida.isPedeCVV2()) {
            CodigoSeguranca seguranca;
            if (dados.getCodigoSeguranca() != null) {
                return FILLED;
            }
            int tamanhoMinimo = 3;
            int tamanhoMaximo = 5;
            if (saida.getTamanhoMinimoCodigoSeguranca() > 0 && saida.getTamanhoMaximoCodigoSeguranca() > 0) {
                tamanhoMinimo = saida.getTamanhoMinimoCodigoSeguranca();
                tamanhoMaximo = saida.getTamanhoMaximoCodigoSeguranca();
            }
            if (dados.getEntradaIntegracao() != null) {
                CodigoSeguranca segurancao = new CodigoSeguranca();
                if (dados.getEntradaIntegracao().isCodigoSeguracaCtrl()) {
                    String codSeguranca = dados.getEntradaIntegracao().getCodigoSeguraca();
                    if (codSeguranca.length() < tamanhoMinimo || codSeguranca.length() > tamanhoMaximo) {
                        dados.setErroIntegracao(new CodigoErroIntegracao(5304, MSG_INVALID_COD_SEGURANCA));
                        return INVALID_LENGTH_AC;
                    }
                    if (codSeguranca.trim().length() == 0) {
                        dados.setCodigoSeguranca(segurancao);
                        segurancao.setMotivo(1);
                        return SUCESS;
                    }
                    segurancao.setCodigo(codSeguranca);
                    dados.setCodigoSeguranca(segurancao);
                    return SUCESS;
                }
                if (dados.getEntradaIntegracao().isMultiTerminal()) {
                    if (saida.isObrigatorioCVV2()) {
                        dados.setErroIntegracao(new CodigoErroIntegracao(5304, MSG_INVALID_COD_SEGURANCA));
                        return INVALID_LENGTH_AC;
                    }
                    segurancao.setMotivo(0);
                    dados.setCodigoSeguranca(segurancao);
                    return SUCESS;
                }
            }
            ControladorPerifericos periferico = dados.getPerifericos();
            String valor = null;
            int caracteresDigitados = 0;
            while (valor == null || caracteresDigitados == 0 && saida.isObrigatorioCVV2() || caracteresDigitados < tamanhoMinimo && caracteresDigitados >= 1) {
                LayoutDisplay displayModel;
                EventoTeclado eventoTeclado;
                if (valor == null) {
                    valor = "";
                }
                if ((eventoTeclado = (EventoTeclado)periferico.capturaDado(displayModel = new LayoutDisplay(inter.getMessage("CODIGO_SEGURANCA")), ConstantesApiAc.CAP_CVV2)).getTeclaFinalizadora().equals("VOLTA")) {
                    return USERCANCEL;
                }
                caracteresDigitados = eventoTeclado.getNumCaracteresDigitados();
                int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
                valor = eventoTeclado.getStringLida().substring(num);
            }
            if (valor.length() >= tamanhoMinimo && valor.length() <= tamanhoMaximo) {
                seguranca = new CodigoSeguranca();
                seguranca.setCodigo(valor);
                dados.setCodigoSeguranca(seguranca);
            } else if (valor == null || valor.equals("")) {
                seguranca = new CodigoSeguranca();
                seguranca.setCodigo("");
                dados.setCodigoSeguranca(seguranca);
                LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage("TITLE_MOTIVO"), true);
                layoutMenu.addItem(new ItemMenu(inter.getMessage("ITEM_MOTIVO1"), "0"));
                layoutMenu.addItem(new ItemMenu(inter.getMessage("ITEM_MOTIVO2"), "1"));
                int opcao = periferico.imprimeMenu(layoutMenu);
                if (opcao == -1) {
                    dados.setCodigoSeguranca(null);
                    return USERCANCEL_MOTIVO;
                }
                switch (opcao) {
                    case 0: {
                        dados.getCodigoSeguranca().setMotivo(0);
                        break;
                    }
                    case 1: {
                        dados.getCodigoSeguranca().setMotivo(1);
                    }
                }
            } else {
                this.exibeMensagem(dados.getPerifericos(), inter.getMessage(INVALID_LENGTH));
                return INVALID_LENGTH;
            }
        }
        return SUCESS;
    }

    private void exibeMensagem(ControladorPerifericos perifericos, String msg) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(msg);
        perifericos.confirmaDado(displayModel);
    }
}

