/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDadoPlano;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.PlanoAVista;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.math.BigDecimal;

public class MicCapturaCompraSaque {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String ERROR_AC = "ERROR_AC";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String INVALID_NUMBER = "INVALID_NUMBER";
    private static final String MSG_DADOS_INVALIDOS = "DADOS INVALIDOS";

    /*
     * Enabled aggressive block sorting
     */
    public String execute(IDadoPlano dado) throws ExcecaoApiAc {
        PlanoAVista plano;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (dado.getTipoFinanciamento() != null && (plano = (PlanoAVista)dado.getTipoFinanciamento()).getValorSaque() != null) {
            return FILLED;
        }
        ControladorPerifericos perifericos = dado.getPerifericos();
        PlanoAVista plano2 = null;
        if (!(dado.getTipoFinanciamento() instanceof PlanoAVista)) throw new IllegalStateException("Financiamento n\u00e3o permite compra e saque");
        plano2 = (PlanoAVista)dado.getTipoFinanciamento();
        if (dado.getEntradaIntegracao() != null && dado.getEntradaIntegracao().isValorSaqueCtrl()) {
            if (dado.getSaidaApiTef().isCompraSaque()) {
                if (this.isValidaValorSaque(dado, dado.getEntradaIntegracao().getValorSaque())) {
                    plano2 = (PlanoAVista)dado.getTipoFinanciamento();
                    plano2.setValorSaque(dado.getEntradaIntegracao().getValorSaque());
                    return SUCESS;
                }
                dado.setErroIntegracao(new CodigoErroIntegracao(5307, MSG_DADOS_INVALIDOS));
                return ERROR_AC;
            }
            if (dado.getEntradaIntegracao().getValorSaque().longValue() > 0L) {
                dado.setErroIntegracao(new CodigoErroIntegracao(5307, MSG_DADOS_INVALIDOS));
                return ERROR_AC;
            }
            plano2.setValorSaque(new BigDecimal(0));
            return SUCESS;
        }
        if (!dado.getSaidaApiTef().isCompraSaque()) return SUCESS;
        String issuer = dado.getSaidaApiTef().getNomeIssuer();
        if (!(ProtocoloBibliotecaCompartilhada.isBibliotecaEMV() || issuer != null && issuer.length() != 0)) {
            issuer = dado.getSaidaApiTef().getLogomarca();
        }
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(issuer));
        displayModel.addLinha(new Linha(inter.getMessage("CAPCOMSAQ_TITLE")));
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_VALOR_SAQUE, false, 8, false);
        if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
            return USERCANCEL;
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        String digitos = eventoTeclado.getStringLida().substring(num);
        if (digitos.equals("")) {
            digitos = "000";
        }
        BigDecimal valor = new BigDecimal(digitos);
        if (!this.isValidaValorSaque(dado, valor = valor.movePointLeft(2))) {
            if (!this.exibeMensagem(inter.getMessage("VALVALCAN_INVALID_VALUE"), perifericos).equals("ENTRA")) return USERCANCEL;
            return INVALID_NUMBER;
        }
        if (!(valor.doubleValue() > 0.0)) return SUCESS;
        plano2.setValorSaque(valor);
        return SUCESS;
    }

    private boolean isValidaValorSaque(IDadoPlano dados, BigDecimal valorSaque) {
        BigDecimal valorMaxSaque = dados.getSaidaApiTef().getValorMaxSaque();
        if (valorMaxSaque != null && valorMaxSaque.doubleValue() > 0.0) {
            return valorSaque.compareTo(valorMaxSaque) != 1;
        }
        return true;
    }

    private String exibeMensagem(String msg, ControladorPerifericos perifericos) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(msg);
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.confirmaDado(displayModel);
        return eventoTeclado.getTeclaFinalizadora();
    }
}

