/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.processleituracartao.ProcessLeituraPin;
import com.csi.ctfclient.operacoes.entrada.IConfirmacaoPositiva;
import com.csi.ctfclient.operacoes.model.ConfirmacaoPositiva;
import com.csi.ctfclient.operacoes.model.Criptografia;
import com.csi.ctfclient.operacoes.model.DadosConfirmacaoPositiva;
import com.csi.ctfclient.operacoes.model.PinInfo;
import com.csi.ctfclient.operacoes.model.RegistroCriptografia;
import com.csi.ctfclient.operacoes.model.TabelaCriptografia;
import com.csi.ctfclient.tools.devices.emv.DadoSolicitaPin;
import com.csi.ctfclient.tools.util.CriptografiaUtil;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicCapturaConfirmacaoPositiva {
    public static final String SUCESS = "SUCESS";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";
    public static final String FILLED = "FILLED";
    public static final String ERRO = "ERRO";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String USER_CANCEL_INTERNAL = "USER_CANCEL_INTERNAL";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(IConfirmacaoPositiva dados) {
        if (dados.getDadosConfirmacaoPositiva() != null && dados.getDadosConfirmacaoPositiva().getPinCriptogravado() != null) {
            return FILLED;
        }
        SaidaApiTefC saida = dados.getSaidaApiTef();
        DadosConfirmacaoPositiva dadosConfirmacaoPositiva = saida.getConfirmacaoPositiva();
        List listConfirmacaoPositiva = dadosConfirmacaoPositiva.getListConfirmacaoPositiva();
        Iterator iterator = listConfirmacaoPositiva.iterator();
        DadoSolicitaPin[] dadoSolicitaPins = new DadoSolicitaPin[listConfirmacaoPositiva.size()];
        int iConfirmacaoPositiva = 0;
        while (iterator.hasNext()) {
            ConfirmacaoPositiva confirmacaoPositiva = (ConfirmacaoPositiva)iterator.next();
            dadoSolicitaPins[iConfirmacaoPositiva] = new DadoSolicitaPin(confirmacaoPositiva.getTamanhoMinimo(), confirmacaoPositiva.getTamanhoMaximo(), confirmacaoPositiva.getPrompt());
            ++iConfirmacaoPositiva;
        }
        if (listConfirmacaoPositiva.size() > 0) {
            Criptografia criptografia = null;
            TabelaCriptografia tabelaCriptografia = dados.getTabelaCriptografia();
            RegistroCriptografia registroCriptografia = tabelaCriptografia.getCriptografiaSenhaPrincipal();
            int modoCriptografia = registroCriptografia.getAlgoritmo();
            String workingKey = StringUtil.completaString(registroCriptografia.getWorkingKey().trim(), 32, '0', false);
            int indiceCriptografia = registroCriptografia.getIndiceMasterKey() == 42 ? 0 : registroCriptografia.getIndiceMasterKey();
            criptografia = new Criptografia(modoCriptografia, indiceCriptografia, workingKey, registroCriptografia.isIndiceAuttar());
            ProcessManager processManager = ProcessManager.getInstance();
            boolean possuiChaveContingencia = CriptografiaUtil.possuiChaveContingencia(registroCriptografia, tabelaCriptografia.getCriptografiaSenhaContingencia());
            if (dadosConfirmacaoPositiva.getVersao() == 1) {
                String numeroSerieChaveDUKPT = null;
                for (int i = 0; i < dadoSolicitaPins.length; ++i) {
                    DadoSolicitaPin dadoSolicitaPin = dadoSolicitaPins[i];
                    DadoSolicitaPin[] solicitaPin = new DadoSolicitaPin[]{dadoSolicitaPin};
                    ProcessLeituraPin processLeituraPin = new ProcessLeituraPin(dados.getCartao(), criptografia, solicitaPin, false, possuiChaveContingencia);
                    processLeituraPin.setActiveDialogUserCancel(false);
                    processLeituraPin.setTituloAguardaPin(dadoSolicitaPin.getMensagemSolicitacao().trim());
                    try {
                        processManager.subProcess(dados.getIdProcess(), processLeituraPin);
                        if (processLeituraPin.getState() == 3) {
                            return USER_CANCEL;
                        }
                        if (processLeituraPin.getState() == 5) {
                            return USER_CANCEL_INTERNAL;
                        }
                        if (processLeituraPin.getState() == 1) {
                            if (processLeituraPin.isUtilizarChaveContingencia()) {
                                return "RERUN";
                            }
                            dados.setErroIntegracao(processLeituraPin.getErroIntegracao());
                            dados.setErrorCode(processLeituraPin.getErrorCode());
                            dados.getSaidaApiTef().setRetorno(20);
                            return ERRO;
                        }
                        if (dadosConfirmacaoPositiva.getPinCriptogravado() == null) {
                            dadosConfirmacaoPositiva.setPinCriptogravado(processLeituraPin.getPinInfo().getPinCriptografado());
                        } else {
                            String pinCriptografado = dadosConfirmacaoPositiva.getPinCriptogravado();
                            if (i < listConfirmacaoPositiva.size()) {
                                pinCriptografado = pinCriptografado + "#";
                            }
                            pinCriptografado = pinCriptografado + processLeituraPin.getPinInfo().getPinCriptografado();
                            dadosConfirmacaoPositiva.setPinCriptogravado(pinCriptografado);
                        }
                        numeroSerieChaveDUKPT = processLeituraPin.getPinInfo().getNumeroSerieChaveDUKPT();
                        continue;
                    }
                    catch (Exception e) {
                        this.logger.log((Priority)Level.ERROR, (Object)e.getMessage(), (Throwable)e);
                        return ERRO;
                    }
                }
                dadosConfirmacaoPositiva.setNumeroSerieChaveDUKPTConfirmacaoPositiva(numeroSerieChaveDUKPT);
                dados.setDadosConfirmacaoPositiva(dadosConfirmacaoPositiva);
            } else {
                ProcessLeituraPin processLeituraPin = new ProcessLeituraPin(dados.getCartao(), criptografia, dadoSolicitaPins, false, possuiChaveContingencia);
                processLeituraPin.setActiveDialogUserCancel(false);
                processLeituraPin.setTituloAguardaPin(((ConfirmacaoPositiva)listConfirmacaoPositiva.get(0)).getPrompt().trim());
                try {
                    processManager.subProcess(dados.getIdProcess(), processLeituraPin);
                    if (processLeituraPin.getState() == 3) {
                        return USER_CANCEL;
                    }
                    if (processLeituraPin.getState() == 5) {
                        return USER_CANCEL_INTERNAL;
                    }
                    if (processLeituraPin.getState() == 1) {
                        if (processLeituraPin.isUtilizarChaveContingencia()) {
                            return "RERUN";
                        }
                        dados.setErroIntegracao(processLeituraPin.getErroIntegracao());
                        dados.setErrorCode(processLeituraPin.getErrorCode());
                        dados.getSaidaApiTef().setRetorno(20);
                        return ERRO;
                    }
                    PinInfo pinInfo = processLeituraPin.getPinInfo();
                    dadosConfirmacaoPositiva.setPinCriptogravado(pinInfo.getPinCriptografado());
                    dadosConfirmacaoPositiva.setNumeroSerieChaveDUKPTConfirmacaoPositiva(processLeituraPin.getPinInfo().getNumeroSerieChaveDUKPT());
                    dados.setDadosConfirmacaoPositiva(dadosConfirmacaoPositiva);
                }
                catch (Exception e) {
                    this.logger.log((Priority)Level.ERROR, (Object)e.getMessage(), (Throwable)e);
                    return ERRO;
                }
            }
            return SUCESS;
        }
        return NOT_REQUIRED;
    }
}

