/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDadoPlano;
import com.csi.ctfclient.operacoes.entrada.IDataTransacao;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.PlanoCDC;
import com.csi.ctfclient.operacoes.model.PlanoCrediario;
import com.csi.ctfclient.operacoes.model.PlanoParcelado;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.DateUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MicCapturaData1Parcela {
    public static final String FILLED = "FILLED";
    public static final String SUCESS = "SUCESS";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String INVALID_DATE = "INVALID_DATE";
    public static final String INVALID_DATE_AC = "INVALID_DATE_AC";
    public static final String EXCEDE_PRAZO = "EXCEDE_PRAZO";
    public static final String EXCEDE_PRAZO_AC = "EXCEDE_PRAZO_AC";

    public String execute(IDadoPlano dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dados.getPerifericos();
        PlanoParcelado planoParcelado = (PlanoParcelado)dados.getTipoFinanciamento();
        planoParcelado.setPrazoAgendamentoDia(dados.getSaidaApiTef().getMaximoDiasCDC());
        if (!dados.getSaidaApiTef().isData1Parcela()) {
            planoParcelado.setData1parcela(new Date());
            return UNECESSARY;
        }
        if (planoParcelado.getData1parcela() != null) {
            return FILLED;
        }
        if (dados.getEntradaIntegracao() != null && this.isValida1ParcelaCancelamento(dados.getEntradaIntegracao())) {
            if (dados.getEntradaIntegracao().isDataReferenciaCtrl()) {
                int operacao = dados.getEntradaIntegracao().getOperacao();
                if (this.isTransacaoComParcAvista(operacao)) {
                    if (!DateUtil.equalsData(dados.getEntradaIntegracao().getDataReferencia(), dados.getStartProcess())) {
                        dados.setErroIntegracao(new CodigoErroIntegracao(5313, inter.getMessage("CAPDAT1PAR_INVALID_DATE")));
                        return INVALID_DATE_AC;
                    }
                } else if (!this.isTransacaoComParcAvista(operacao) && DateUtil.equalsData(dados.getEntradaIntegracao().getDataReferencia(), dados.getStartProcess())) {
                    dados.setErroIntegracao(new CodigoErroIntegracao(5313, inter.getMessage("CAPDAT1PAR_INVALID_DATE")));
                    return INVALID_DATE_AC;
                }
                if (!planoParcelado.isData1ParcelaValida(dados.getStartProcess(), dados.getEntradaIntegracao().getDataReferencia())) {
                    dados.setErroIntegracao(new CodigoErroIntegracao(5314, inter.getMessage("CAPDAT1PAR_EXCEDE_PRAZO")));
                    return EXCEDE_PRAZO_AC;
                }
                planoParcelado.setData1parcela(dados.getEntradaIntegracao().getDataReferencia());
                return SUCESS;
            }
            if (this.isData1ParcelaObrigarotoria(dados.getEntradaIntegracao().getOperacao()) && this.isTransacaoComParcAvista(dados.getEntradaIntegracao().getOperacao())) {
                planoParcelado.setData1parcela(new Date());
                return SUCESS;
            }
        }
        String dataDigitada = "";
        boolean tamanhoInvalido = true;
        while (tamanhoInvalido) {
            LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("CAPDAT1PAR_TITLE"));
            EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_DATA_1_PARCELA, 0, true, 10, true);
            if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
                return USERCANCEL;
            }
            int num = eventoTeclado.getNumCaracteresDigitados();
            dataDigitada = eventoTeclado.getStringLida().substring(0, num);
            if (dataDigitada.length() == 6) {
                tamanhoInvalido = false;
                continue;
            }
            if (dataDigitada.length() != 0) continue;
            if (planoParcelado instanceof PlanoCrediario || planoParcelado instanceof PlanoCDC && dados.getSaidaApiTef() != null && dados.getSaidaApiTef().isData1ParcelaObrigatoria()) {
                this.exibeMensagemDataInvalida(perifericos, inter.getMessage("CAPDAT1PAR_INVALID_DATE"));
                continue;
            }
            tamanhoInvalido = false;
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat("ddMMyy");
            df.setLenient(false);
            if (dataDigitada.equals("")) {
                planoParcelado.setData1parcela(new Date());
            } else {
                planoParcelado.setData1parcela(df.parse(dataDigitada));
            }
            if (dados.getEntradaIntegracao() != null && !this.isValida1ParcelaCancelamento(dados.getEntradaIntegracao()) && planoParcelado.getData1parcela().compareTo(((IDataTransacao)((Object)dados)).getDataTransacao()) == -1) {
                if (this.exibeMensagemDataInvalida(perifericos, inter.getMessage("CAPDAT1PAR_INVALID_DATE")).equals("ENTRA")) {
                    planoParcelado.setData1parcela(null);
                    return INVALID_DATE;
                }
                return USERCANCEL;
            }
            if (!planoParcelado.isData1ParcelaValida(dados.getStartProcess())) {
                if (this.exibeMensagemPrazoExcedido(perifericos, inter.getMessage("CAPDAT1PAR_EXCEDE_PRAZO")).equals("ENTRA")) {
                    planoParcelado.setData1parcela(null);
                    return EXCEDE_PRAZO;
                }
                return USERCANCEL;
            }
        }
        catch (Exception e) {
            if (this.exibeMensagemDataInvalida(perifericos, inter.getMessage("CAPDAT1PAR_INVALID_DATE")).equals("ENTRA")) {
                planoParcelado.setData1parcela(null);
                return INVALID_DATE;
            }
            return USERCANCEL;
        }
        return SUCESS;
    }

    private String exibeMensagemPrazoExcedido(ControladorPerifericos perifericos, String msgExcedePrazo) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(msgExcedePrazo);
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.confirmaDado(displayModel);
        return eventoTeclado.getTeclaFinalizadora();
    }

    private String exibeMensagemDataInvalida(ControladorPerifericos perifericos, String msgInvalidDate) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(msgInvalidDate);
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.confirmaDado(displayModel);
        return eventoTeclado.getTeclaFinalizadora();
    }

    private boolean isData1ParcelaObrigarotoria(int operacao) {
        if (operacao == 222) {
            return false;
        }
        return operacao != 406 && operacao != 405 && operacao != 900 && operacao != 109 && operacao != 111 && operacao != 267;
    }

    private boolean isTransacaoComParcAvista(int operacao) {
        if (operacao == 105 || operacao == 108 || operacao == 110) {
            return true;
        }
        if (operacao == 104 || operacao == 109 || operacao == 111) {
            return false;
        }
        return false;
    }

    private boolean isValida1ParcelaCancelamento(EntradaCTFClientCtrl entradaIntegracao) {
        return entradaIntegracao.getOperacao() != 128;
    }
}

