/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDadoPlano;
import com.csi.ctfclient.operacoes.entrada.IDataTransacao;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.PlanoPreDatado;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class MicCapturaDataAgendamento {
    public static final String FILLED = "FILLED";
    public static final String SUCESS = "SUCESS";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String EXCEDE_PRAZO = "EXCEDE_PRAZO";
    public static final String EXCEDE_PRAZO_AC = "EXCEDE_PRAZO_AC";
    public static final String INVALID_DATE = "INVALID_DATE";
    public static final String INVALID_DATE_AC = "INVALID_DATE_AC";

    public String execute(IDadoPlano dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dados.getPerifericos();
        PlanoPreDatado planoPreDatado = (PlanoPreDatado)dados.getTipoFinanciamento();
        if (planoPreDatado.getDataAgendamento() != null) {
            return FILLED;
        }
        planoPreDatado.setPrazoAgendamentoDia(dados.getSaidaApiTef().getMaximaDiaPre());
        planoPreDatado.setPrazoMinimoAgendamentoDia(dados.getSaidaApiTef().getMinDiasPre());
        if (dados.getEntradaIntegracao() != null && this.isValidaAgendamentoCancelamento(dados.getEntradaIntegracao()) && dados.getEntradaIntegracao().isDataReferenciaCtrl()) {
            if (!planoPreDatado.isDataMinAgendamento(dados.getStartProcess(), dados.getEntradaIntegracao().getDataReferencia())) {
                dados.setErroIntegracao(new CodigoErroIntegracao(5313, inter.getMessage("CAPDATAGE_INVALID_DATE")));
                return INVALID_DATE_AC;
            }
            if (!planoPreDatado.isDataAgendamentoValida(dados.getStartProcess(), dados.getEntradaIntegracao().getDataReferencia())) {
                dados.setErroIntegracao(new CodigoErroIntegracao(5314, inter.getMessage("CAPDATAGE_EXCEDE_PRAZO")));
                return EXCEDE_PRAZO_AC;
            }
            planoPreDatado.setDataAgendamento(dados.getEntradaIntegracao().getDataReferencia());
            return SUCESS;
        }
        int operacao = 0;
        if (dados.getEntradaIntegracao() != null) {
            operacao = dados.getEntradaIntegracao().getOperacao();
        }
        String dataDigitada = "";
        boolean tamanhoInvalido = true;
        while (tamanhoInvalido) {
            String title = null;
            title = operacao == 128 ? inter.getMessage("CAPDATAGE_TITLE_CANCEL") : inter.getMessage("CAPDATAGE_TITLE");
            LayoutDisplay displayModel = new LayoutDisplay(title);
            EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_DATA_AGENDAMENTO, 0, true, 10, true);
            if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
                return USERCANCEL;
            }
            int num = eventoTeclado.getNumCaracteresDigitados();
            dataDigitada = eventoTeclado.getStringLida().substring(0, num);
            if (dataDigitada.length() != 6) continue;
            tamanhoInvalido = false;
        }
        Date dataAgendamento = null;
        try {
            SimpleDateFormat df = new SimpleDateFormat("ddMMyy");
            df.setLenient(false);
            dataAgendamento = df.parse(dataDigitada);
            GregorianCalendar calender = new GregorianCalendar();
            int qtdDiasPre = dados.getSaidaApiTef().getMinDiasPre();
            if (qtdDiasPre == 0) {
                ++qtdDiasPre;
            }
            if (operacao == 128 && dataAgendamento.compareTo(((IDataTransacao)((Object)dados)).getDataTransacao()) != 1) {
                if (this.exibeMensagemDataInvalida(perifericos, inter.getMessage("CAPDATAGE_INVALID_DATE")).equals("ENTRA")) {
                    planoPreDatado.setDataAgendamento(null);
                    return INVALID_DATE;
                }
                return USERCANCEL;
            }
            calender.setTime(df.parse(df.format(new Date())));
            ((Calendar)calender).add(5, qtdDiasPre);
            if (calender.getTime().compareTo(dataAgendamento) == 1) {
                if (this.exibeMensagemDataInvalida(perifericos, inter.getMessage("CAPDATAGE_INVALID_DATE")).equals("ENTRA")) {
                    planoPreDatado.setDataAgendamento(null);
                    return INVALID_DATE;
                }
                return USERCANCEL;
            }
            if (!planoPreDatado.isDataAgendamentoValida(dados.getStartProcess(), dataAgendamento)) {
                if (this.exibeMensagemPrazoExcedido(perifericos, inter.getMessage("CAPDATAGE_EXCEDE_PRAZO")).equals("ENTRA")) {
                    planoPreDatado.setDataAgendamento(null);
                    return EXCEDE_PRAZO;
                }
                return USERCANCEL;
            }
        }
        catch (Exception e) {
            if (this.exibeMensagemDataInvalida(perifericos, inter.getMessage("CAPDATAGE_INVALID_DATE")).equals("ENTRA")) {
                planoPreDatado.setDataAgendamento(null);
                return INVALID_DATE;
            }
            return USERCANCEL;
        }
        planoPreDatado.setDataAgendamento(dataAgendamento);
        return SUCESS;
    }

    private String exibeMensagemPrazoExcedido(ControladorPerifericos perifericos, String msgExcedePrazo) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(msgExcedePrazo);
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.confirmaDado(displayModel);
        return eventoTeclado.getTeclaFinalizadora();
    }

    private String exibeMensagemDataInvalida(ControladorPerifericos perifericos, String msgInvalidDate) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(msgInvalidDate);
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.confirmaDado(displayModel);
        return eventoTeclado.getTeclaFinalizadora();
    }

    private boolean isValidaAgendamentoCancelamento(EntradaCTFClientCtrl entradaIntegracao) {
        return entradaIntegracao.getOperacao() != 128;
    }
}

