/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDataCheque;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.text.SimpleDateFormat;

public class MicCapturaDataCheque {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String INVALID_DATE = "INVALID_DATE";
    public static final String USER_CANCEL = "USER_CANCEL";

    public String execute(IDataCheque dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (dados.getDataCheque() != null) {
            return FILLED;
        }
        if (dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isDataReferenciaCtrl()) {
            dados.setDataCheque(dados.getEntradaIntegracao().getDataReferencia());
            return SUCESS;
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        String dataDigitada = "";
        boolean tamanhoInvalido = true;
        while (tamanhoInvalido) {
            LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("CAPDATCHE_TITLE"));
            EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_DATA_CHEQUE, 0, true, 10, true);
            if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
                return USER_CANCEL;
            }
            int num = eventoTeclado.getNumCaracteresDigitados();
            dataDigitada = eventoTeclado.getStringLida().substring(0, num);
            if (dataDigitada.length() != 6) continue;
            tamanhoInvalido = false;
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat("ddMMyy");
            df.setLenient(false);
            dados.setDataCheque(df.parse(dataDigitada));
            return SUCESS;
        }
        catch (Exception e) {
            this.exibeMensagemErro(perifericos, inter.getMessage("CAPDATCHE_ERROR"));
            return INVALID_DATE;
        }
    }

    private void exibeMensagemErro(ControladorPerifericos perifericos, String msg) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(msg);
        perifericos.confirmaDado(displayModel);
    }
}

