/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDadoBaixaTecnicaManual;
import com.csi.ctfclient.operacoes.model.DadosBaixaTecnicaManual;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.text.SimpleDateFormat;

public class MicCapturaDataHoraBaixaTecnica {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String INVALID_DATE = "INVALID_DATE";

    public String execute(IDadoBaixaTecnicaManual dado) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dado.getPerifericos();
        DadosBaixaTecnicaManual dadoBaixaTecnicaManual = dado.getDadosBaixaTecnicaManual();
        if (dadoBaixaTecnicaManual.getDataBaixaTecnica() != null) {
            if (!this.dataValida(dado)) {
                if (this.exibeMensagemDataInvalida(perifericos, inter.getMessage("CAPDATHORBAITEC_ERROR")).equals("ENTRA")) {
                    return INVALID_DATE;
                }
                return USER_CANCEL;
            }
            return FILLED;
        }
        String dataDigitada = "";
        boolean tamanhoInvalido = true;
        while (tamanhoInvalido) {
            LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("CAPDATHORBAITEC_TITLE"));
            EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_DATA_BAIXA_TECNICA, 0, false, 19, true);
            if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
                return USER_CANCEL;
            }
            int num = eventoTeclado.getNumCaracteresDigitados();
            dataDigitada = eventoTeclado.getStringLida().substring(0, num);
            if (dataDigitada.length() != 10) continue;
            tamanhoInvalido = false;
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat("ddMMyyHHmm");
            df.setLenient(false);
            dadoBaixaTecnicaManual.setDataBaixaTecnica(df.parse(dataDigitada));
        }
        catch (Exception e) {
            if (this.exibeMensagemDataInvalida(perifericos, inter.getMessage("CAPDATHORBAITEC_ERROR")).equals("ENTRA")) {
                return INVALID_DATE;
            }
            return USER_CANCEL;
        }
        if (!this.dataValida(dado)) {
            dadoBaixaTecnicaManual.setDataBaixaTecnica(null);
            if (this.exibeMensagemDataInvalida(perifericos, inter.getMessage("CAPDATHORBAITEC_ERROR")).equals("ENTRA")) {
                return INVALID_DATE;
            }
            return USER_CANCEL;
        }
        return SUCESS;
    }

    private String exibeMensagemDataInvalida(ControladorPerifericos perifericos, String msg) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(msg);
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.confirmaDado(displayModel);
        return eventoTeclado.getTeclaFinalizadora();
    }

    private boolean dataValida(IDadoBaixaTecnicaManual dado) {
        return !dado.getDadosBaixaTecnicaManual().getDataBaixaTecnica().after(dado.getStartProcess());
    }
}

