/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.ICapturaDataNascimentoCliente;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.DateUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MicCapturaDataNascimentoCliente {
    public static final String SUCCESS = "SUCCESS";
    public static final String SUCCESS_BLANK = "SUCCESS_BLANK";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String INVALID_DATE = "INVALID_DATE";
    public static final String INVALID_DATE_AC = "INVALID_DATE_AC";

    public String execute(ICapturaDataNascimentoCliente dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (dados.getDataNascimentoCliente() != null) {
            return FILLED;
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        if (dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isDataNascimentoClienteCtrl()) {
            if (this.validaDataNascimento(dados.getEntradaIntegracao().getDataNascimentoCliente())) {
                dados.setDataNascimentoCliente(dados.getEntradaIntegracao().getDataNascimentoCliente());
                return SUCCESS;
            }
            dados.setErroIntegracao(new CodigoErroIntegracao(5385, "Data de nascimento do Cliente inv\u00e1lida"));
            return INVALID_DATE_AC;
        }
        if (dados.getEntradaIntegracao().isMultiTerminal()) {
            return SUCCESS_BLANK;
        }
        String dataDigitada = "";
        boolean tamanhoInvalido = true;
        while (tamanhoInvalido) {
            LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("CAPDATNASCLI_TITLE"));
            EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_DATA_NASCIMENTO_CLIENTE, 0, true, 10, true);
            if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
                return USER_CANCEL;
            }
            int num = eventoTeclado.getNumCaracteresDigitados();
            dataDigitada = eventoTeclado.getStringLida().substring(0, num);
            if (dataDigitada.length() != 6) continue;
            tamanhoInvalido = false;
        }
        try {
            Date dataNascimento = this.parseDataNascimento(dataDigitada);
            dados.setDataNascimentoCliente(dataNascimento);
            return SUCCESS;
        }
        catch (IllegalArgumentException e) {
            this.exibeMensagemErro(perifericos, inter.getMessage("CAPDATVEN_ERROR"));
            return INVALID_DATE;
        }
    }

    private Date parseDataNascimento(String dataDigitada) {
        SimpleDateFormat df = new SimpleDateFormat("ddMMyy");
        df.setLenient(false);
        try {
            Date dataNascimento = df.parse(dataDigitada);
            if (this.validaDataNascimento(dataNascimento)) {
                return dataNascimento;
            }
            throw new IllegalArgumentException();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException();
        }
    }

    private boolean validaDataNascimento(Date dataNascimento) {
        return DateUtil.removerHora(new Date()).compareTo(dataNascimento) > 0;
    }

    private void exibeMensagemErro(ControladorPerifericos perifericos, String msg) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(msg);
        perifericos.confirmaDado(displayModel);
    }
}

