/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDataTransacao;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class MicCapturaDataReimpressao {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USERCANCEL";
    public static final String INVALID_DATE = "INVALID_DATE";
    private InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();

    public String execute(IDataTransacao dado) throws ExcecaoNaoLocal {
        ControladorPerifericos perifericos = dado.getPerifericos();
        if (dado.getDataTransacao() != null) {
            if (!this.dataValida(dado)) {
                if (this.exibeMensagemDataInvalida(perifericos).equals("ENTRA")) {
                    return INVALID_DATE;
                }
                return USER_CANCEL;
            }
            return FILLED;
        }
        String dataDigitada = "";
        boolean tamanhoInvalido = true;
        while (tamanhoInvalido) {
            LayoutDisplay displayModel = new LayoutDisplay(this.inter.getMessage("CAPDATREIMP_TITLE"));
            EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_DATA_TRANSACAO_ORIGINAL, 0, false, 19, true);
            if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
                return USER_CANCEL;
            }
            int num = eventoTeclado.getNumCaracteresDigitados();
            dataDigitada = eventoTeclado.getStringLida().substring(0, num);
            if (dataDigitada.length() != 6) continue;
            tamanhoInvalido = false;
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat("ddMMyy");
            df.setLenient(false);
            dado.setDataTransacao(df.parse(dataDigitada));
        }
        catch (Exception e) {
            if (this.exibeMensagemDataInvalida(perifericos).equals("ENTRA")) {
                return INVALID_DATE;
            }
            return USER_CANCEL;
        }
        if (!this.dataValida(dado)) {
            dado.setDataTransacao(null);
            if (this.exibeMensagemDataInvalida(perifericos).equals("ENTRA")) {
                return INVALID_DATE;
            }
            return USER_CANCEL;
        }
        return SUCESS;
    }

    private String exibeMensagemDataInvalida(ControladorPerifericos perifericos) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(this.inter.getMessage("CAPDATREIMP_ERROR"));
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.confirmaDado(displayModel);
        return eventoTeclado.getTeclaFinalizadora();
    }

    private boolean dataValida(IDataTransacao dado) {
        Date dataAtual;
        if (dado.getDataTransacao().after(dado.getStartProcess())) {
            return false;
        }
        Calendar calender = GregorianCalendar.getInstance();
        calender.setTime(dado.getStartProcess());
        calender.add(5, -2);
        SimpleDateFormat format = new SimpleDateFormat("ddMMyy");
        try {
            dataAtual = format.parse(format.format(calender.getTime()));
        }
        catch (ParseException e) {
            return false;
        }
        return !dado.getDataTransacao().before(dataAtual);
    }
}

