/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDataVencimento;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.DateUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.text.SimpleDateFormat;

public class MicCapturaDataVencimento {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String INVALID_DATE = "INVALID_DATE";
    public static final String CONFIRM_VALUE = "CONFIRM_VALUE";
    public static final String INVALID_CONFIRMATION = "INVALID_CONFIRMATION";

    public String execute(IDataVencimento dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (dados.getSaidaApiTef() != null && !dados.getSaidaApiTef().isCapturaDataVencimento()) {
            return UNECESSARY;
        }
        if (dados.getDataVencimento() != null && !dados.isConfirmacaoDataVencimento()) {
            return FILLED;
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        String dataDigitada = "";
        boolean tamanhoInvalido = true;
        while (tamanhoInvalido) {
            LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("CAPDATVEN_TITLE"));
            EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_DATA_VENCIMENTO_DOCUMENTO, 0, true, 10, true);
            if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
                return USER_CANCEL;
            }
            int num = eventoTeclado.getNumCaracteresDigitados();
            dataDigitada = eventoTeclado.getStringLida().substring(0, num);
            if (dataDigitada.length() != 6) continue;
            tamanhoInvalido = false;
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat("ddMMyy");
            df.setLenient(false);
            if (!dados.isConfirmacaoDataVencimento()) {
                dados.setDataVencimento(df.parse(dataDigitada));
                dados.setConfirmacaoDataVencimento(true);
                return CONFIRM_VALUE;
            }
            if (DateUtil.equalsData(df.parse(dataDigitada), dados.getDataVencimento())) {
                return SUCESS;
            }
            this.exibeMensagemErro(perifericos, inter.getMessage("CAPDATVEN_INVALID_CONFIRMATION"));
            if (!dados.isDataVencimentoLida()) {
                dados.setDataVencimento(null);
                dados.setConfirmacaoDataVencimento(false);
            }
            return INVALID_CONFIRMATION;
        }
        catch (Exception e) {
            this.exibeMensagemErro(perifericos, inter.getMessage("CAPDATVEN_ERROR"));
            return INVALID_DATE;
        }
    }

    private void exibeMensagemErro(ControladorPerifericos perifericos, String msg) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(msg);
        perifericos.confirmaDado(displayModel);
    }
}

