/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.operacoes.entrada.IDigitoVerificadorTelefone;
import com.csi.ctfclient.tools.util.StringUtil;

public class MicCapturaDigitoVerificadorTelefone {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String UNNECESSARY = "UNNECESSARY";

    public String execute(IDigitoVerificadorTelefone dados) {
        if (dados.getOperadoraTelefonia() == null || !dados.getOperadoraTelefonia().isDigito()) {
            return UNNECESSARY;
        }
        if (dados.getDigitoVerificadorTelefone() != 0) {
            return FILLED;
        }
        if (dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isDigitoVerificadorTelefoneCtrl()) {
            dados.setDigitoVerificadorTelefone(dados.getEntradaIntegracao().getDigitoVerificadorTelefone());
        }
        String telefoneFormatado = StringUtil.completaString(dados.getDDD() + dados.getTelefone(), 13, '0', 3);
        int digito = this.modulo11(telefoneFormatado);
        dados.setDigitoVerificadorTelefone(digito);
        return SUCESS;
    }

    private int modulo11(String numero) {
        int soma = 0;
        int size = numero.length();
        int[] base = new int[]{2, 7, 6, 5, 4, 3, 2, 7, 6, 5, 4, 3, 2};
        for (int i = size - 1; i > 0; --i) {
            soma += Integer.parseInt(numero.substring(i, i + 1)) * base[i];
        }
        int dac = 11 - soma % 11;
        if (dac == 10 || dac == 11) {
            dac = 0;
        }
        return dac;
    }

    public static void main(String[] args) {
        String telefone = "0003188046151";
        telefone = "7891177771234";
        telefone = "0001177770000";
        MicCapturaDigitoVerificadorTelefone mic = new MicCapturaDigitoVerificadorTelefone();
        int mod = mic.modulo11(telefone);
        System.out.println(mod);
    }
}

