/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDadoCartaoMutable;
import com.csi.ctfclient.operacoes.model.Cartao;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class MicCapturaEmissaoCartao {
    public static final String SUCCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String ERRO_INVALID_DATA = "ERRO_INVALID_DATA";
    public static final String ERRO_INVALID_DATA_AC = "ERRO_INVALID_DATA_AC";

    public String execute(IDadoCartaoMutable dadoCartao) throws ExcecaoNaoLocal, IllegalArgumentException {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (dadoCartao.getSaidaApiTef() != null && !dadoCartao.getSaidaApiTef().isCapturaDataEmissao()) {
            return UNECESSARY;
        }
        if (dadoCartao.getCartao().getEmissao() != null) {
            return FILLED;
        }
        if (dadoCartao.getEntradaIntegracao() != null) {
            if (dadoCartao.getEntradaIntegracao().isDataEmissaoCtrl()) {
                String dataEmissaoAC = dadoCartao.getEntradaIntegracao().getDataEmissao();
                if (dataEmissaoAC.length() != 8 || !this.isDataEmissaoValida(dataEmissaoAC.substring(2, 8))) {
                    dadoCartao.setErroIntegracao(new CodigoErroIntegracao(5383, inter.getMessage("VENCAR_NOT_VALID_DATE")));
                    return ERRO_INVALID_DATA_AC;
                }
                Cartao cartao = dadoCartao.getCartao();
                cartao.setEmissao(dataEmissaoAC.substring(2, 8));
                return SUCCESS;
            }
            if (dadoCartao.getEntradaIntegracao().isMultiTerminal()) {
                dadoCartao.setErroIntegracao(new CodigoErroIntegracao(5383, inter.getMessage("VENCAR_NOT_VALID_DATE")));
                return ERRO_INVALID_DATA_AC;
            }
        }
        Cartao cartao = dadoCartao.getCartao();
        ControladorPerifericos perifericos = dadoCartao.getPerifericos();
        String digitos = null;
        int qtdDigitado = 0;
        while (qtdDigitado < 6) {
            LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("EMISSAOCAR_TITLE"));
            EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_DATA_EMISSAO_CARTAO, 0, false, 9, true);
            if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
                return USERCANCEL;
            }
            qtdDigitado = eventoTeclado.getNumCaracteresDigitados();
            int num = eventoTeclado.getNumCaracteresDigitados();
            digitos = eventoTeclado.getStringLida().substring(0, num);
        }
        if (!this.isDataEmissaoValida(digitos)) {
            this.exibeMensagem(perifericos, inter.getMessage("VENCAR_NOT_VALID_DATE"));
            return ERRO_INVALID_DATA;
        }
        cartao.setEmissao(digitos);
        return SUCCESS;
    }

    private void exibeMensagem(ControladorPerifericos perifericos, String messagem) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(messagem);
        perifericos.confirmaDado(displayModel);
    }

    private boolean isDataEmissaoValida(String dataInformada) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMyyyy");
        dateFormat.setLenient(false);
        try {
            dateFormat.parse(dataInformada);
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }
}

