/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDadosEndereco;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaEndereco {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String INVALID_ENDERECO_AC = "INVALID_ENDERECO_AC";
    private static final String MSG_INVALID_ENDERECO = "ENDERECO INVALIDO";

    public String execute(IDadosEndereco dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (dados.getEndereco() != null) {
            return FILLED;
        }
        if (dados.getEntradaIntegracao() != null) {
            if (dados.getEntradaIntegracao().isEnderecoCtrl()) {
                dados.setEndereco(dados.getEntradaIntegracao().getEndereco());
                return SUCESS;
            }
            if (dados.getEntradaIntegracao().isMultiTerminal()) {
                dados.setErroIntegracao(new CodigoErroIntegracao(5399, MSG_INVALID_ENDERECO));
                return INVALID_ENDERECO_AC;
            }
        }
        String valor = null;
        int caracteresDigitados = 0;
        ControladorPerifericos periferico = dados.getPerifericos();
        while (caracteresDigitados == 0) {
            LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("CAPEND_TITLE"));
            EventoTeclado eventoTeclado = (EventoTeclado)periferico.capturaDado(displayModel, ConstantesApiAc.CAP_ENDERECO);
            if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                return USER_CANCEL;
            }
            int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
            valor = eventoTeclado.getStringLida().substring(num).trim();
            caracteresDigitados = valor.length();
        }
        dados.setEndereco(valor);
        return SUCESS;
    }
}

