/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDadoPlano;
import com.csi.ctfclient.operacoes.model.PlanoAVista;
import com.csi.ctfclient.operacoes.model.PlanoAdministradora;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.util.Vector;
import org.apache.log4j.Logger;

public class MicCapturaFinanciamentoSaque {
    public static final String SAQUE_AVISTA = "SAQUE_AVISTA";
    public static final String SAQUE_PARCELADO = "SAQUE_PARCELADO";
    public static final String FILLED = "FILLED";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String ERROR = "ERROR";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String SIMULACAO = "SIMULACAO";

    public String execute(IDadoPlano dados) throws ExcecaoNaoLocal {
        Logger logger = CTFClientLogger.getCTFClient();
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        boolean habilitadoAVista = dados.getSaidaApiTef().isPedePlanoAVista();
        boolean habilitadoParcelado = dados.getSaidaApiTef().isPedePlanoAdministradora();
        EntradaCTFClientCtrl entradaIntegracao = dados.getEntradaIntegracao();
        if (dados.getTipoFinanciamento() != null) {
            return FILLED;
        }
        if (entradaIntegracao != null) {
            if (entradaIntegracao.getOperacao() == 246) {
                return UNECESSARY;
            }
            if (entradaIntegracao.getOperacao() == 248 || entradaIntegracao.getOperacao() == 249) {
                dados.setTipoFinanciamento(new PlanoAdministradora());
                return SIMULACAO;
            }
            if (!habilitadoParcelado && (!entradaIntegracao.isNumeroParcelasCtrl() || entradaIntegracao.isNumeroParcelasCtrl() && entradaIntegracao.getNumeroParcelas() <= 1)) {
                logger.info((Object)"plano parcelado n\u00e3o habilitado. selecionado plano a vista");
                dados.setTipoFinanciamento(new PlanoAVista());
                return SAQUE_AVISTA;
            }
        }
        if (entradaIntegracao != null && dados.getEntradaIntegracao().isNumeroParcelasCtrl()) {
            logger.info((Object)("numero de parcelas informada pela ac = " + entradaIntegracao.getNumeroParcelas()));
            if (entradaIntegracao.getNumeroParcelas() > 1) {
                PlanoAdministradora planoAdministradora = new PlanoAdministradora();
                dados.setTipoFinanciamento(planoAdministradora);
                return SAQUE_PARCELADO;
            }
            dados.setTipoFinanciamento(new PlanoAVista());
            return SAQUE_AVISTA;
        }
        Vector<String> vtTitleMenu = new Vector<String>();
        if (habilitadoAVista) {
            vtTitleMenu.add(inter.getMessage("LEITIPFIN_MENU_AVISTA"));
        }
        if (habilitadoParcelado) {
            vtTitleMenu.add(inter.getMessage("LEITIPFINCRE_MENU_PARCELADO"));
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        if (vtTitleMenu.size() == 0) {
            dados.setTipoFinanciamento(null);
            return ERROR;
        }
        if (vtTitleMenu.size() == 1) {
            if (habilitadoAVista) {
                dados.setTipoFinanciamento(new PlanoAVista());
                return SAQUE_AVISTA;
            }
            if (habilitadoParcelado) {
                dados.setTipoFinanciamento(new PlanoAdministradora());
                return SAQUE_PARCELADO;
            }
        } else {
            LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage("LEITIPFIN_TITLE"), true);
            int iTecla = 1;
            for (int i = 0; i < vtTitleMenu.size(); ++i) {
                layoutMenu.addItem(new ItemMenu((String)vtTitleMenu.get(i), String.valueOf(iTecla)));
                ++iTecla;
            }
            int opcao = perifericos.imprimeMenu(layoutMenu);
            if (opcao == -1) {
                return USERCANCEL;
            }
            ItemMenu itemSelecionado = (ItemMenu)layoutMenu.getItens().get(opcao - 1);
            if (itemSelecionado.getTexto().equals(inter.getMessage("LEITIPFIN_MENU_AVISTA"))) {
                dados.setTipoFinanciamento(new PlanoAVista());
                return SAQUE_AVISTA;
            }
            if (itemSelecionado.getTexto().equals(inter.getMessage("LEITIPFINCRE_MENU_PARCELADO"))) {
                dados.setTipoFinanciamento(new PlanoAdministradora());
                return SAQUE_PARCELADO;
            }
        }
        return ERROR;
    }
}

