/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IIdentificacaoPagamento;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaIdentificacaoPagamento {
    public static final String SUCCESS = "SUCCESS";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String ERROR = "ERROR";

    public String execute(IIdentificacaoPagamento dados) throws ExcecaoNaoLocal {
        if (dados.getIdentificacaoPagamento() > 0) {
            return FILLED;
        }
        EntradaCTFClientCtrl entradaIntegracao = dados.getEntradaIntegracao();
        if (entradaIntegracao != null && entradaIntegracao.isFormaIdentificacaoPagamentoFaturaCtrl()) {
            if (entradaIntegracao.getFormaIdentificacaoPagamentoFatura() == 1 || entradaIntegracao.getFormaIdentificacaoPagamentoFatura() == 2) {
                dados.setIdentificacaoPagamento(entradaIntegracao.getFormaIdentificacaoPagamentoFatura());
                return SUCCESS;
            }
            dados.setErroIntegracao(new CodigoErroIntegracao(5397, "VALOR DA FORMA DE IDENTIFICA\u00c7\u00c3O DO PAGAMENTO DE FATURA INV\u00c1LIDO"));
            return ERROR;
        }
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage("CAPIDEPAG_TITLE"), true);
        layoutMenu.addItem(new ItemMenu(inter.getMessage("CAPIDEPAG_CARTAO"), "1"));
        layoutMenu.addItem(new ItemMenu(inter.getMessage("CAPIDEPAG_CODIGO_BARRAS"), "2"));
        ControladorPerifericos perifericos = dados.getPerifericos();
        int opcao = perifericos.imprimeMenu(layoutMenu);
        if (opcao == -1) {
            dados.setIdentificacaoPagamento(0);
            return USER_CANCEL;
        }
        switch (opcao) {
            case 1: {
                dados.setIdentificacaoPagamento(1);
                break;
            }
            case 2: {
                dados.setIdentificacaoPagamento(2);
            }
        }
        return SUCCESS;
    }
}

