/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IConvenioCombustivelShell;
import com.csi.ctfclient.operacoes.entrada.IInformacoesAdicionais;
import com.csi.ctfclient.operacoes.model.InformacoesAdicionais;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicCapturaInformacoesAdicionais {
    public static final String SUCESS = "SUCESS";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String ERROR = "ERROR";
    private static final String ZERO_LENGTH = "ZERO_LENGTH";
    private static final String INVALID_LENGTH = "INVALID_LENGTH";
    private static final String TECLA_VOLTA = "TECLA_VOLTA";
    private static Logger logger = CTFClientLogger.getCTFClient();

    public String execute(IInformacoesAdicionais dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        String dadoDigitado = "";
        String dadoDigitadoConfirmacao = "";
        ControladorPerifericos perifericos = dados.getPerifericos();
        SaidaApiTefC saida = dados.getSaidaApiTef();
        List listInformacoesAdicionais = saida.getInformacoesAdicionais();
        int ordemCaptura = 0;
        if (dados instanceof IConvenioCombustivelShell) {
            ordemCaptura = ((IConvenioCombustivelShell)dados).getOrdemCapturaInformacaoAdicional();
        }
        listInformacoesAdicionais = this.filtrarListPorOrdemCaptura(listInformacoesAdicionais, ordemCaptura);
        for (InformacoesAdicionais informacoesAdicionais : listInformacoesAdicionais) {
            if (dados.getListInformacoesAdicionais() != null && dados.getListInformacoesAdicionais().size() > 0 && dados.getListInformacoesAdicionais().contains(informacoesAdicionais)) {
                logger.log((Priority)Level.INFO, (Object)("Informa\u00e7\u00e3o j\u00e1 capturada: Tabela: " + informacoesAdicionais.getCodigoTabela() + ", grupo: " + informacoesAdicionais.getCodigoGrupo() + ", Informa\u00e7\u00e3o: " + informacoesAdicionais.getCodigoInformacao() + ", Descri\u00e7\u00e3o: " + informacoesAdicionais.getMensagemDisplay()));
                continue;
            }
            dadoDigitado = "";
            dadoDigitadoConfirmacao = "";
            boolean continuaLendo = true;
            while (continuaLendo) {
                try {
                    dadoDigitado = this.capturaDadoAdicional(perifericos, informacoesAdicionais);
                    if (dadoDigitado.equals(USER_CANCEL)) {
                        return USER_CANCEL;
                    }
                    if (informacoesAdicionais.isDuplaDigitacao() && !dadoDigitado.equals(dadoDigitadoConfirmacao = this.capturaDadoAdicional(perifericos, informacoesAdicionais))) {
                        LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("CAPINFADI_INVALID_DATA"), 1500L);
                        perifericos.imprimeDisplay(displayModel);
                        continuaLendo = true;
                        continue;
                    }
                    informacoesAdicionais.setTamanhoInformacaoAdicional(dadoDigitado.length());
                    informacoesAdicionais.setMensagemInformacaoAdicional(dadoDigitado);
                    continuaLendo = false;
                }
                catch (IllegalArgumentException e) {
                    if (!e.getMessage().equals(ZERO_LENGTH)) {
                        if (e.getMessage().equals(INVALID_LENGTH)) {
                            LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("CAPINFADI_INVALID_SIZE"), 1500L);
                            perifericos.imprimeDisplay(displayModel);
                        } else if (e.getMessage().equals(TECLA_VOLTA)) {
                            return USER_CANCEL;
                        }
                    }
                    continuaLendo = true;
                }
            }
        }
        if (dados.getListInformacoesAdicionais() != null && dados.getListInformacoesAdicionais().size() > 0) {
            dados.getListInformacoesAdicionais().addAll(listInformacoesAdicionais);
        } else {
            dados.setListInformacoesAdicionais(listInformacoesAdicionais);
        }
        if (listInformacoesAdicionais.size() > 0) {
            return SUCESS;
        }
        return NOT_REQUIRED;
    }

    private String capturaDadoAdicional(ControladorPerifericos perifericos, InformacoesAdicionais informacoesAdicionais) throws IllegalArgumentException, ExcecaoNaoLocal {
        EventoTeclado eventoTeclado = null;
        if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_BOOLEANO)) {
            LayoutMenu menu = new LayoutMenu(informacoesAdicionais.getMensagemDisplay(), true);
            menu.addItem(new ItemMenu("SIM", "1"));
            menu.addItem(new ItemMenu("NAO", "2"));
            int resultado = perifericos.imprimeMenu(menu);
            switch (resultado) {
                case -1: {
                    return USER_CANCEL;
                }
                case 1: {
                    return "1";
                }
                case 2: {
                    return "0";
                }
            }
            return ERROR;
        }
        ConstantesApiAc.TipoCampo tipoCampo = null;
        LayoutDisplay displayModel = new LayoutDisplay(informacoesAdicionais.getMensagemDisplay());
        if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_NUMERICO)) {
            tipoCampo = new ConstantesApiAc.TipoCampo(ConstantesApiAc.CAP_INFORMACOES_ADICIONAIS.getCodigo(), ConstantesApiAc.CAP_INFORMACOES_ADICIONAIS.getDescricao(), this.getMascaraNumerico(informacoesAdicionais.getTamanhoMaximo()));
        } else if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_INTEIRO)) {
            tipoCampo = new ConstantesApiAc.TipoCampo(ConstantesApiAc.CAP_INFORMACOES_ADICIONAIS.getCodigo(), ConstantesApiAc.CAP_INFORMACOES_ADICIONAIS.getDescricao(), StringUtil.completaString("Z", informacoesAdicionais.getTamanhoMaximo(), 'Z', 4));
        } else if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_DATA)) {
            tipoCampo = new ConstantesApiAc.TipoCampo(ConstantesApiAc.CAP_INFORMACOES_ADICIONAIS.getCodigo(), ConstantesApiAc.CAP_INFORMACOES_ADICIONAIS.getDescricao(), "99//99//9999");
        } else if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_ALFA_NUMERICO)) {
            tipoCampo = new ConstantesApiAc.TipoCampo(ConstantesApiAc.CAP_INFORMACOES_ADICIONAIS.getCodigo(), ConstantesApiAc.CAP_INFORMACOES_ADICIONAIS.getDescricao(), StringUtil.completaString("@", informacoesAdicionais.getTamanhoMaximo(), '@', 4));
        } else if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_NUMERICO_TRES_CASAS_DECIMAIS)) {
            tipoCampo = new ConstantesApiAc.TipoCampo(ConstantesApiAc.CAP_INFORMACOES_ADICIONAIS.getCodigo(), ConstantesApiAc.CAP_INFORMACOES_ADICIONAIS.getDescricao(), this.getMascaraNumerico(informacoesAdicionais.getTamanhoMaximo(), 3));
        }
        eventoTeclado = tipoCampo != null ? (EventoTeclado)perifericos.capturaDado(displayModel, tipoCampo) : (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_INFORMACOES_ADICIONAIS, informacoesAdicionais.getTamanhoMaximo());
        if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
            throw new IllegalArgumentException(TECLA_VOLTA);
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        String dadoDigitado = eventoTeclado.getStringLida().substring(num);
        if (dadoDigitado.length() < informacoesAdicionais.getTamanhoMinimo()) {
            if (dadoDigitado.equals("")) {
                throw new IllegalArgumentException(ZERO_LENGTH);
            }
            throw new IllegalArgumentException(INVALID_LENGTH);
        }
        return dadoDigitado;
    }

    private String getMascaraNumerico(int tamanho, int precisaoDecimal) {
        if (tamanho == 0) {
            return "Z.ZZZ.ZZZ.ZZ9,99";
        }
        if (precisaoDecimal == 0) {
            precisaoDecimal = 2;
        }
        String mascaraTemp = "";
        for (int i = 0; i < tamanho; ++i) {
            if (i < precisaoDecimal + 1) {
                if (i == precisaoDecimal) {
                    mascaraTemp = "," + mascaraTemp;
                }
                mascaraTemp = "9" + mascaraTemp;
                continue;
            }
            if ((i - precisaoDecimal) % 3 == 0) {
                mascaraTemp = "." + mascaraTemp;
            }
            mascaraTemp = "Z" + mascaraTemp;
        }
        return mascaraTemp.toString();
    }

    private String getMascaraNumerico(int tamanho) {
        return this.getMascaraNumerico(tamanho, 2);
    }

    private List filtrarListPorOrdemCaptura(List listOriginal, int ordemCaptura) {
        if (ordemCaptura == 0) {
            return listOriginal;
        }
        ArrayList<InformacoesAdicionais> listNova = new ArrayList<InformacoesAdicionais>();
        for (InformacoesAdicionais infoAdic : listOriginal) {
            if (infoAdic.getOrdemCaptura() != ordemCaptura) continue;
            listNova.add(infoAdic);
        }
        return listNova;
    }

    public static void main(String[] args) {
        MicCapturaInformacoesAdicionais d = new MicCapturaInformacoesAdicionais();
        System.out.println(d.getMascaraNumerico(12));
        for (int i = 0; i < 100; ++i) {
            System.out.println(d.getMascaraNumerico(i));
        }
    }
}

