/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.ICapturaMatriculaSupervisor;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaMatriculaSupervisor {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";

    public String execute(ICapturaMatriculaSupervisor dado) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (dado.getSaidaApiTef() != null && !dado.getSaidaApiTef().isMatriculaSupervisor()) {
            return NOT_REQUIRED;
        }
        if (dado.getMatriculaSupervisor() != null) {
            return FILLED;
        }
        if (dado.getEntradaIntegracao() != null && dado.getEntradaIntegracao().isMatriculaSupervisorCtrl()) {
            dado.setMatricualaSupervisor(dado.getEntradaIntegracao().getMatriculaSupervisor());
            return SUCESS;
        }
        ControladorPerifericos periferico = dado.getPerifericos();
        String valor = null;
        int caracteresDigitados = 0;
        while (caracteresDigitados == 0) {
            LayoutDisplay layoutDisplay = new LayoutDisplay();
            layoutDisplay.addLinha(new Linha(inter.getMessage("CAPMATSUP_TITLE")));
            EventoTeclado eventoTeclado = (EventoTeclado)periferico.capturaDado(layoutDisplay, ConstantesApiAc.CAP_MATRICULA_SUPERVISOR);
            if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                return USER_CANCEL;
            }
            caracteresDigitados = eventoTeclado.getNumCaracteresDigitados();
            int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
            valor = eventoTeclado.getStringLida().substring(num);
        }
        dado.setMatricualaSupervisor(valor);
        return SUCESS;
    }
}

