/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.processleituracartao.ProcessGoOnChip;
import com.csi.ctfclient.operacoes.action.processleituracartao.ProcessLeituraPin;
import com.csi.ctfclient.operacoes.entrada.ICapturaMudancaSenha;
import com.csi.ctfclient.operacoes.model.Criptografia;
import com.csi.ctfclient.operacoes.model.PinInfo;
import com.csi.ctfclient.operacoes.model.RegistroCriptografia;
import com.csi.ctfclient.operacoes.model.TabelaCriptografia;
import com.csi.ctfclient.operacoes.model.controller.PinpadUtil;
import com.csi.ctfclient.tools.devices.emv.DadoSolicitaPin;
import com.csi.ctfclient.tools.util.CriptografiaUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.math.BigDecimal;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicCapturaMudancaSenha {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    public static final String ERROR_FALLBACK = "ERROR_FALLBACK";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String USER_CANCEL_INTERNAL = "USER_CANCEL_INTERNAL";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(ICapturaMudancaSenha dados) throws ExcecaoApiAc {
        SaidaApiTefC saida = dados.getSaidaApiTef();
        if (!saida.isCapturaDadosChip()) {
            return ERROR;
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        TabelaCriptografia tabelaCriptografia = dados.getTabelaCriptografia();
        RegistroCriptografia registroCriptografia = tabelaCriptografia.getCriptografiaSenhaPrincipal();
        int modoCriptografia = registroCriptografia.getAlgoritmo();
        String workingKey = registroCriptografia.getWorkingKey();
        int indiceCriptografia = registroCriptografia.getIndiceMasterKey() == 42 ? 0 : registroCriptografia.getIndiceMasterKey();
        Criptografia criptografia = new Criptografia(modoCriptografia, indiceCriptografia, workingKey);
        dados.setCriptografia(criptografia);
        BigDecimal valorTotal = dados.getValorTransacao();
        BigDecimal valorSaque = new BigDecimal(0);
        boolean possuiChaveContingencia = CriptografiaUtil.possuiChaveContingencia(registroCriptografia, tabelaCriptografia.getCriptografiaSenhaContingencia());
        possuiChaveContingencia = false;
        ProcessGoOnChip processGoOnChip = new ProcessGoOnChip(saida, criptografia, valorTotal, valorSaque, dados.getEntradaIntegracao(), possuiChaveContingencia);
        processGoOnChip.setActiveDialogUserCancel(false);
        ProcessManager manager = ProcessManager.getInstance();
        try {
            manager.subProcess(dados.getIdProcess(), processGoOnChip);
            PinInfo pinInfo = processGoOnChip.getPinInfo();
            dados.setPinInfo(pinInfo);
            if (pinInfo != null) {
                dados.setNumeroSerieChaveDUKPTSenha(pinInfo.getNumeroSerieChaveDUKPT());
            }
            dados.setErrorCode(processGoOnChip.getErrorCode());
            dados.setErroIntegracao(processGoOnChip.getErroIntegracao());
            String retorno = this.trataRetornoGoOnChip(dados, processGoOnChip);
            if (!retorno.equals(SUCCESS)) {
                return retorno;
            }
            dados.setTagsMandatorias(saida.getTagsMandatorias());
            DadoSolicitaPin[] dadoSolicitaPin = new DadoSolicitaPin[]{new DadoSolicitaPin(4, 12, PinpadUtil.montaDisplayNovaSenha())};
            ProcessLeituraPin processLeituraPin = new ProcessLeituraPin(dados.getCartao(), criptografia, dadoSolicitaPin, true, saida, possuiChaveContingencia);
            processLeituraPin.setActiveDialogUserCancel(false);
            processLeituraPin.setTituloAguardaPin(inter.getMessage("CAPMUDSEN_NOVA_SENHA"));
            manager.subProcess(dados.getIdProcess(), processLeituraPin);
            String retornoNovaSenha = this.trataRetornoGetPin(dados, processLeituraPin);
            if (!retornoNovaSenha.equals(SUCCESS)) {
                dados.setErrorCode(processLeituraPin.getErrorCode());
                dados.setErroIntegracao(processLeituraPin.getErroIntegracao());
                if (processLeituraPin.getRemoveCardMessage() != null) {
                    dados.setRemoveCardMessage(processLeituraPin.getRemoveCardMessage());
                }
                return retornoNovaSenha;
            }
            dados.setPinInfoNovaSenha(processLeituraPin.getPinInfo());
            DadoSolicitaPin[] dadoSolicitaPinConfirmacao = new DadoSolicitaPin[]{new DadoSolicitaPin(4, 12, PinpadUtil.montaDisplayConfirmacaoNovaSenha())};
            ProcessLeituraPin processLeituraPinConfirmacao = new ProcessLeituraPin(dados.getCartao(), criptografia, dadoSolicitaPinConfirmacao, true, saida, possuiChaveContingencia);
            processLeituraPinConfirmacao.setActiveDialogUserCancel(false);
            processLeituraPinConfirmacao.setTituloAguardaPin(inter.getMessage("CAPMUDSEN_CONFIRMA_NOVA_SENHA"));
            manager.subProcess(dados.getIdProcess(), processLeituraPinConfirmacao);
            String retornoCofirmacaoNovaSenha = this.trataRetornoGetPin(dados, processLeituraPinConfirmacao);
            if (!retornoCofirmacaoNovaSenha.equals(SUCCESS)) {
                dados.setErrorCode(processLeituraPinConfirmacao.getErrorCode());
                dados.setErroIntegracao(processLeituraPinConfirmacao.getErroIntegracao());
                if (processLeituraPinConfirmacao.getRemoveCardMessage() != null) {
                    dados.setRemoveCardMessage(processLeituraPinConfirmacao.getRemoveCardMessage());
                }
                return retornoCofirmacaoNovaSenha;
            }
            dados.setPinInfoNovaSenhaConfirmacao(processLeituraPinConfirmacao.getPinInfo());
        }
        catch (Exception e) {
            this.logger.log((Priority)Level.ERROR, (Object)e.getMessage(), (Throwable)e);
            return ERROR;
        }
        return SUCCESS;
    }

    private String trataRetornoGoOnChip(ICapturaMudancaSenha dados, ProcessGoOnChip processGoOnChip) {
        if (processGoOnChip.getState() == 3) {
            dados.setRemoveCardMessage("OPERACAO        CANCELADA");
            return USER_CANCEL;
        }
        if (processGoOnChip.getState() == 1) {
            if (processGoOnChip.getErrorCode() == 50 || processGoOnChip.getErrorCode() == 60 || processGoOnChip.getErrorCode() == 61 || processGoOnChip.getErrorCode() == 70 || processGoOnChip.getErrorCode() == 76) {
                dados.setCartaoAnterior(dados.getCartao());
                dados.setCartao(null);
                dados.setSaidaApiTef(null);
                dados.setLastErrorCode(processGoOnChip.getErrorCode());
                return ERROR_FALLBACK;
            }
            return ERROR;
        }
        if (processGoOnChip.getState() == 5) {
            dados.setRemoveCardMessage("OPERACAO        CANCELADA");
            return USER_CANCEL_INTERNAL;
        }
        return SUCCESS;
    }

    private String trataRetornoGetPin(ICapturaMudancaSenha dados, ProcessLeituraPin process) {
        if (process.getState() == 3) {
            dados.setRemoveCardMessage("OPERACAO        CANCELADA");
            return USER_CANCEL;
        }
        if (process.getState() == 1) {
            if (process.getErrorCode() == 42) {
                return "RERUN";
            }
            return ERROR;
        }
        if (process.getState() == 5) {
            return USER_CANCEL;
        }
        return SUCCESS;
    }
}

