/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.INsuTransacao;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaNsuTransacao {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String INVALID_NSU = "INVALID_NSU";
    public static final String INVALID_NSU_AC = "INVALID_NSU_AC";

    /*
     * Enabled aggressive block sorting
     */
    public String execute(INsuTransacao dado) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (dado.getNsuTransacao() != 0) {
            return FILLED;
        }
        if (dado.getEntradaIntegracao() != null && dado.getEntradaIntegracao().isNsuCTFCtrl()) {
            if (dado.getEntradaIntegracao().getNsuCTF() > 0 && dado.getEntradaIntegracao().getNsuCTF() < 999999) {
                dado.setNsuTransacao(dado.getEntradaIntegracao().getNsuCTF());
                return SUCESS;
            }
            dado.setErroIntegracao(new CodigoErroIntegracao(5316, inter.getMessage("CAPNSUTRA_INVALID_NSU")));
            return INVALID_NSU_AC;
        }
        ControladorPerifericos perifericos = dado.getPerifericos();
        String valor = null;
        int caracteresDigitados = 0;
        while (true) {
            LayoutDisplay displayModel;
            EventoTeclado eventoTeclado;
            if (valor != null && caracteresDigitados >= 6) {
                dado.setNsuTransacao(Integer.parseInt(valor));
                return SUCESS;
            }
            if (valor == null) {
                valor = "";
            }
            if ((eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel = new LayoutDisplay(inter.getMessage("CAPNSUTRA_TITLE")), ConstantesApiAc.CAP_NSU_CTF_CANCELAMENTO, true, 7, true)).getTeclaFinalizadora().equals("VOLTA")) {
                return USER_CANCEL;
            }
            caracteresDigitados = eventoTeclado.getNumCaracteresDigitados();
            if (caracteresDigitados < 6) {
                displayModel = new LayoutDisplay(inter.getMessage("CAPNSUTRA_INVALID_LENGTH"), 1500L);
                perifericos.imprimeDisplay(displayModel);
            }
            int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
            valor = eventoTeclado.getStringLida().substring(num);
        }
    }
}

