/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDadosNumero;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaNumero {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String INVALID_NUMBER = "INVALID_NUMBER";
    public static final String INVALID_NUMBER_AC = "INVALID_NUMBER_AC";
    private static final String MSG_INVALID_NUMBER = "NUMERO DO ENDERECO INVALIDO";

    public String execute(IDadosNumero dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (dados.getNumero() != null) {
            return FILLED;
        }
        if (dados.getEntradaIntegracao() != null) {
            if (dados.getEntradaIntegracao().isNumeroCtrl()) {
                dados.setNumero(dados.getEntradaIntegracao().getNumero());
                return SUCESS;
            }
            if (dados.getEntradaIntegracao().isMultiTerminal()) {
                dados.setErroIntegracao(new CodigoErroIntegracao(5399, MSG_INVALID_NUMBER));
                return INVALID_NUMBER_AC;
            }
        }
        String valor = null;
        int caracteresDigitados = 0;
        ControladorPerifericos periferico = dados.getPerifericos();
        while (caracteresDigitados == 0) {
            LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("CAPNUM_TITLE"));
            EventoTeclado eventoTeclado = (EventoTeclado)periferico.capturaDado(displayModel, ConstantesApiAc.CAP_NUMERO_ENDERECO);
            if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                return USER_CANCEL;
            }
            int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
            valor = eventoTeclado.getStringLida().substring(num);
            caracteresDigitados = valor.length();
        }
        dados.setNumero(valor);
        return SUCESS;
    }
}

