/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDadoPlano;
import com.csi.ctfclient.operacoes.model.IPlanoPrivateLabel;
import com.csi.ctfclient.operacoes.model.Plano;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaNumeroCiclos {
    public static final String SUCESS = "SUCESS";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String FILLED = "FILLED";
    public static final String NUMERO_CICLOS_INVALIDO = "NUMERO_INVALIDO";
    public static final String NUMERO_CICLOS_INVALIDO_AC = "NUMERO_INVALIDO_AC";

    public String execute(IDadoPlano dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dados.getPerifericos();
        EntradaCTFClientCtrl entradaIntegracao = dados.getEntradaIntegracao();
        if (!(dados.getTipoFinanciamento() instanceof IPlanoPrivateLabel) && dados.getSaidaApiTef() != null && !dados.getSaidaApiTef().isCapturaCiclos()) {
            return SUCESS;
        }
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        if (entradaIntegracao != null && !conf.isIntegracaoWeb()) {
            if (dados.getTipoFinanciamento() instanceof IPlanoPrivateLabel && ((IPlanoPrivateLabel)((Object)dados.getTipoFinanciamento())).getNumeroCiclos() >= 0) {
                return FILLED;
            }
            if (dados.getTipoFinanciamento() instanceof Plano && dados.getTipoFinanciamento().getNumeroCiclos() >= 0) {
                return FILLED;
            }
        }
        if (dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isCiclosPularCtrl()) {
            if (dados.getTipoFinanciamento() instanceof IPlanoPrivateLabel) {
                IPlanoPrivateLabel planoPrivateLabel = (IPlanoPrivateLabel)((Object)dados.getTipoFinanciamento());
                planoPrivateLabel.setNumeroCiclos(dados.getEntradaIntegracao().getCiclosPular());
            } else if (dados.getTipoFinanciamento() instanceof Plano) {
                Plano plano = dados.getTipoFinanciamento();
                plano.setNumeroCiclos(dados.getEntradaIntegracao().getCiclosPular());
            }
            return SUCESS;
        }
        if (conf.isIntegracaoWeb()) {
            return SUCESS;
        }
        LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("CAPNUMCIC_TITLE"));
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_NUMERO_CICLO, true, 14, true);
        if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
            return USERCANCEL;
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        String digitos = eventoTeclado.getStringLida().substring(num);
        int numCiclos = 0;
        if (!"".equals(digitos.trim())) {
            numCiclos = Integer.parseInt(digitos);
        }
        if (dados.getTipoFinanciamento() instanceof IPlanoPrivateLabel) {
            IPlanoPrivateLabel planoPrivateLabel = (IPlanoPrivateLabel)((Object)dados.getTipoFinanciamento());
            planoPrivateLabel.setNumeroCiclos(numCiclos);
        } else if (dados.getTipoFinanciamento() instanceof Plano) {
            Plano plano = dados.getTipoFinanciamento();
            plano.setNumeroCiclos(numCiclos);
        }
        return SUCESS;
    }
}

