/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDadoPlano;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.PlanoAPrazo;
import com.csi.ctfclient.operacoes.model.PlanoAdministradora;
import com.csi.ctfclient.operacoes.model.PlanoCDC;
import com.csi.ctfclient.operacoes.model.PlanoFinanciadoLojista;
import com.csi.ctfclient.operacoes.model.PlanoIATA;
import com.csi.ctfclient.operacoes.model.PlanoParcelado;
import com.csi.ctfclient.operacoes.model.PlanoParceleMais;
import com.csi.ctfclient.operacoes.model.PlanoPrivateLabelPrazo;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import org.apache.log4j.Logger;

public class MicCapturaNumeroParcela {
    private static Logger logger = CTFClientLogger.getCTFClient();
    public static final String SUCESS = "SUCESS";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String FILLED = "FILLED";
    public static final String PARCELA_INVALIDA = "PARCELA_INVALIDA";
    public static final String PARCELA_INVALIDA_AC = "PARCELA_INVALIDA_AC";

    public String execute(IDadoPlano dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dados.getPerifericos();
        PlanoAPrazo planoAPrazo = this.getPlano(dados);
        logger.info((Object)("N\u00famero minimo de parcelas: " + planoAPrazo.getNumeroMinParcela()));
        logger.info((Object)("N\u00famero maximo de parcelas: " + planoAPrazo.getNumeroMaxParcela()));
        if (dados.getEntradaIntegracao() != null) {
            if (dados.getEntradaIntegracao().isNumeroParcelasCtrl()) {
                logger.info((Object)("Parcela informada AC: " + dados.getEntradaIntegracao().getNumeroParcelas()));
                if (dados.getTipoFinanciamento() instanceof PlanoFinanciadoLojista) {
                    if (dados.getValorTransacao() != null && !planoAPrazo.isValorMinParcelaSemJuros(dados.getValorTransacao(), dados.getEntradaIntegracao().getNumeroParcelas())) {
                        dados.setErroIntegracao(new CodigoErroIntegracao(5308, inter.getMessage("CAPNUMPAR_VALOR_MIN_PARCELA")));
                        return PARCELA_INVALIDA_AC;
                    }
                } else if (dados.getTipoFinanciamento() instanceof PlanoAdministradora && dados.getValorTransacao() != null && planoAPrazo.getValorMinParcelaComJuros() != null && !planoAPrazo.isValorMinParcelaComJuros(dados.getValorTransacao(), dados.getEntradaIntegracao().getNumeroParcelas())) {
                    dados.setErroIntegracao(new CodigoErroIntegracao(5308, inter.getMessage("CAPNUMPAR_VALOR_MIN_PARCELA")));
                    return PARCELA_INVALIDA_AC;
                }
                if (this.isVerificaRotativo(dados.getSaidaApiTef().isRotativoHabilitado(), dados.getEntradaIntegracao().getNumeroParcelas()) && !planoAPrazo.isNumeroMinValido(dados.getEntradaIntegracao().getNumeroParcelas())) {
                    dados.setErroIntegracao(new CodigoErroIntegracao(5309, inter.getMessage("CAPNUMPAR_NR_PARC_INVALIDO")));
                    return PARCELA_INVALIDA_AC;
                }
                if (!planoAPrazo.isNumeroMaxValido(dados.getEntradaIntegracao().getNumeroParcelas())) {
                    dados.setErroIntegracao(new CodigoErroIntegracao(5310, inter.getMessage("CAPNUMPAR_EXCEDE_PARCELA")));
                    return PARCELA_INVALIDA_AC;
                }
                planoAPrazo.setNumeroParcela(dados.getEntradaIntegracao().getNumeroParcelas());
                return SUCESS;
            }
            if (this.parcelaObrigatoria(dados.getEntradaIntegracao().getOperacao())) {
                dados.setErroIntegracao(new CodigoErroIntegracao(5309, inter.getMessage("CAPNUMPAR_NR_PARC_INVALIDO")));
                return PARCELA_INVALIDA_AC;
            }
        }
        if (planoAPrazo != null && planoAPrazo.getNumeroParcela() >= 0) {
            return FILLED;
        }
        LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("CAPNUMPAR_TITLE"));
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_NUMERO_PARCELAS, true, 14, true);
        if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
            return USERCANCEL;
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        String numParcelas = eventoTeclado.getStringLida().substring(num);
        int parcelas = 0;
        try {
            parcelas = Integer.parseInt(numParcelas);
            logger.info((Object)("N\u00famero parcelas digitada: " + parcelas));
        }
        catch (NumberFormatException e) {
            if (this.exibeMensagem(inter.getMessage("CAPNUMPAR_NR_PARC_INVALIDO"), perifericos).equals("ENTRA")) {
                return PARCELA_INVALIDA;
            }
            return USERCANCEL;
        }
        if (this.isVerificaRotativo(dados.getSaidaApiTef().isRotativoHabilitado(), parcelas) && !planoAPrazo.isNumeroMinValido(parcelas)) {
            if (this.exibeMensagem(inter.getMessage("CAPNUMPAR_NR_PARC_INVALIDO"), perifericos).equals("ENTRA")) {
                logger.info((Object)("n\u00famero de parcelas invalido, " + inter.getMessage("CAPNUMPAR_NR_PARC_INVALIDO")));
                return PARCELA_INVALIDA;
            }
            return USERCANCEL;
        }
        if (!planoAPrazo.isNumeroMaxValido(parcelas)) {
            if (this.exibeMensagem(inter.getMessage("CAPNUMPAR_EXCEDE_PARCELA"), perifericos).equals("ENTRA")) {
                logger.info((Object)("excede parcelas, " + inter.getMessage("CAPNUMPAR_EXCEDE_PARCELA")));
                return PARCELA_INVALIDA;
            }
            return USERCANCEL;
        }
        if (dados.getTipoFinanciamento() instanceof PlanoFinanciadoLojista) {
            if (dados.getValorTransacao() != null && !dados.getSaidaApiTef().isRotativoHabilitado() && !planoAPrazo.isValorMinParcelaSemJuros(dados.getValorTransacao(), parcelas)) {
                if (this.exibeMensagem(inter.getMessage("CAPNUMPAR_VALOR_MIN_PARCELA"), perifericos).equals("ENTRA")) {
                    return PARCELA_INVALIDA;
                }
                return USERCANCEL;
            }
        } else if (dados.getTipoFinanciamento() instanceof PlanoAdministradora && dados.getValorTransacao() != null && planoAPrazo.getValorMinParcelaComJuros() != null && !dados.getSaidaApiTef().isRotativoHabilitado() && !planoAPrazo.isValorMinParcelaComJuros(dados.getValorTransacao(), parcelas)) {
            if (this.exibeMensagem(inter.getMessage("CAPNUMPAR_VALOR_MIN_PARCELA"), perifericos).equals("ENTRA")) {
                return PARCELA_INVALIDA;
            }
            return USERCANCEL;
        }
        planoAPrazo.setNumeroParcela(parcelas);
        return SUCESS;
    }

    private boolean isVerificaRotativo(boolean rotativo, int parcelas) {
        return !rotativo || parcelas != 0 && parcelas != 1;
    }

    private PlanoAPrazo getPlano(IDadoPlano dadoPlano) throws IllegalStateException {
        PlanoAPrazo plano = null;
        if (dadoPlano.getTipoFinanciamento() instanceof PlanoAdministradora) {
            PlanoAdministradora planoAdministradora = (PlanoAdministradora)dadoPlano.getTipoFinanciamento();
            planoAdministradora.setNumeroMaxParcela(dadoPlano.getSaidaApiTef().getQtdMaximaParcelaComJuros());
            planoAdministradora.setNumeroMinParcela(dadoPlano.getSaidaApiTef().getQtdMinimaParcelaComJuros());
            planoAdministradora.setValorMinParcelaComJuros(dadoPlano.getSaidaApiTef().getValorMinimoParcelaComJuros());
            plano = planoAdministradora;
        } else if (dadoPlano.getTipoFinanciamento() instanceof PlanoFinanciadoLojista) {
            PlanoFinanciadoLojista financiadoLojista = (PlanoFinanciadoLojista)dadoPlano.getTipoFinanciamento();
            financiadoLojista.setNumeroMaxParcela(dadoPlano.getSaidaApiTef().getQtdMaximaParcelaSemJuros());
            financiadoLojista.setNumeroMinParcela(dadoPlano.getSaidaApiTef().getQtdMinimaParcelaSemJuros());
            financiadoLojista.setValorMinParcelaSemJuros(dadoPlano.getSaidaApiTef().getValorMinimoParcelaSemJuros());
            plano = financiadoLojista;
        } else if (dadoPlano.getTipoFinanciamento() instanceof PlanoIATA) {
            PlanoIATA planoIATA = (PlanoIATA)dadoPlano.getTipoFinanciamento();
            planoIATA.setNumeroMaxParcela(dadoPlano.getSaidaApiTef().getQtdMaximaParcelaSemJuros());
            planoIATA.setNumeroMinParcela(dadoPlano.getSaidaApiTef().getQtdMinimaParcelaSemJuros());
            plano = planoIATA;
        } else if (dadoPlano.getTipoFinanciamento() instanceof PlanoCDC) {
            PlanoCDC planoCDC = (PlanoCDC)dadoPlano.getTipoFinanciamento();
            planoCDC.setNumeroMaxParcela(dadoPlano.getSaidaApiTef().getQtdMaximaParcelaComJuros());
            planoCDC.setNumeroMinParcela(dadoPlano.getSaidaApiTef().getQtdMinimaParcelaComJuros());
            plano = planoCDC;
        } else if (dadoPlano.getTipoFinanciamento() instanceof PlanoParceleMais) {
            PlanoParceleMais planoParceleMais = (PlanoParceleMais)dadoPlano.getTipoFinanciamento();
            planoParceleMais.setNumeroMaxParcela(dadoPlano.getSaidaApiTef().getQtdMaximaParcelaSemJuros());
            planoParceleMais.setNumeroMinParcela(dadoPlano.getSaidaApiTef().getQtdMinimaParcelaSemJuros());
            plano = planoParceleMais;
        } else if (dadoPlano.getTipoFinanciamento() instanceof PlanoParcelado) {
            PlanoParcelado planoParcelado = (PlanoParcelado)dadoPlano.getTipoFinanciamento();
            planoParcelado.setNumeroMaxParcela(dadoPlano.getSaidaApiTef().getQtdMaximaParcelaSemJuros());
            planoParcelado.setNumeroMinParcela(dadoPlano.getSaidaApiTef().getQtdMinimaParcelaSemJuros());
            plano = planoParcelado;
        } else if (dadoPlano.getTipoFinanciamento() instanceof PlanoPrivateLabelPrazo) {
            PlanoPrivateLabelPrazo planoPrivateLabelPrazo = (PlanoPrivateLabelPrazo)dadoPlano.getTipoFinanciamento();
            planoPrivateLabelPrazo.setNumeroMaxParcela(dadoPlano.getSaidaApiTef().getQtdMaximaParcelaComJuros());
            planoPrivateLabelPrazo.setNumeroMinParcela(dadoPlano.getSaidaApiTef().getQtdMinimaParcelaComJuros());
            plano = planoPrivateLabelPrazo;
        }
        if (plano != null) {
            return plano;
        }
        throw new IllegalStateException("Plano A prazo invalido");
    }

    private String exibeMensagem(String msg, ControladorPerifericos perifericos) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(msg);
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.confirmaDado(displayModel);
        return eventoTeclado.getTeclaFinalizadora();
    }

    private boolean parcelaObrigatoria(int operacao) {
        return false;
    }
}

