/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.ITransacoesSAA;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import org.apache.log4j.Logger;

public class MicCapturaNumeroParcelaPlanoPagamento {
    public static final String SUCCESS = "SUCCESS";
    public static final String FILLED = "FILLED";
    public static final String PARCELA_INVALIDA = "PARCELA_INVALIDA";
    public static final String USER_CANCEL = "USER_CANCEL";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(ITransacoesSAA dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dados.getPerifericos();
        if (dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isNumeroParcelasCtrl()) {
            this.logger.info((Object)("Parcela informada AC: " + dados.getEntradaIntegracao().getNumeroParcelas()));
            dados.setNumeroParcela(dados.getEntradaIntegracao().getNumeroParcelas());
            return SUCCESS;
        }
        if (dados.getNumeroParcela() > 0) {
            return FILLED;
        }
        LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("CAPNUMPARPLAPAG_TITLE"));
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_NUMERO_PARCELAS, true, 14, true);
        if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
            return USER_CANCEL;
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        String numParcelas = eventoTeclado.getStringLida().substring(num);
        int parcelas = 0;
        try {
            parcelas = Integer.parseInt(numParcelas);
            this.logger.info((Object)("N\u00famero parcelas digitada: " + parcelas));
        }
        catch (NumberFormatException e) {
            if (this.exibeMensagem(inter.getMessage("CAPNUMPAR_NR_PARC_INVALIDO"), perifericos).equals("ENTRA")) {
                return PARCELA_INVALIDA;
            }
            return USER_CANCEL;
        }
        dados.setNumeroParcela(parcelas);
        return SUCCESS;
    }

    private String exibeMensagem(String msg, ControladorPerifericos perifericos) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(msg);
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.confirmaDado(displayModel);
        return eventoTeclado.getTeclaFinalizadora();
    }
}

