/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDadoPlano;
import com.csi.ctfclient.operacoes.model.IPlanoPrivateLabel;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaNumeroPlano {
    public static final String SUCESS = "SUCESS";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String FILLED = "FILLED";
    public static final String NUMERO_PLANO_INVALIDO = "NUMERO_INVALIDO";
    public static final String NUMERO_PLANO_INVALIDO_AC = "NUMERO_INVALIDO_AC";

    public String execute(IDadoPlano dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dados.getPerifericos();
        IPlanoPrivateLabel planoPrivateLabel = (IPlanoPrivateLabel)((Object)dados.getTipoFinanciamento());
        if (!planoPrivateLabel.getNumeroPlano().equals("")) {
            return FILLED;
        }
        if (dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isNumeroPlanoCtrl()) {
            planoPrivateLabel.setNumeroPlano(dados.getEntradaIntegracao().getNumeroPlano());
            return SUCESS;
        }
        LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("CAPNUMPLA_TITLE"));
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_NUMERO_PLANO, true, 14, true);
        if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
            return USERCANCEL;
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        String numPlano = eventoTeclado.getStringLida().substring(num);
        planoPrivateLabel.setNumeroPlano(numPlano);
        return SUCESS;
    }
}

