/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.ICapturaOperadoraTelefonia;
import com.csi.ctfclient.operacoes.model.DadosPersistencia;
import com.csi.ctfclient.operacoes.model.Operadora;
import com.csi.ctfclient.operacoes.model.OperadoraTelefonia;
import com.csi.ctfclient.operacoes.model.controller.ControladorPersistencia;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicCapturaOperadoraTelefonia {
    public static final String SUCCESS = "SUCCESS";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";
    private static Logger logger = CTFClientLogger.getCTFClient();

    public String execute(ICapturaOperadoraTelefonia dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (dados.getOperadoraTelefonia() != null) {
            return FILLED;
        }
        DadosPersistencia dadosPersistencia = null;
        ControladorPersistencia controladorPersistencia = ControladorPersistencia.getInstance();
        ConfCTFClient config = ControladorConfCTFClient.getInstance().getConfig();
        IdentTerminal identTerminal = null;
        identTerminal = dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isMultiTerminal() ? dados.getEntradaIntegracao().getIdentTerminal() : new IdentTerminal(config.getEstabelecimento(), config.getLoja(), config.getTerminal());
        dadosPersistencia = controladorPersistencia.getDadosPersistencia(identTerminal, config.getVersaoPathTerminal());
        List listOperadoras = (List)dadosPersistencia.getListOperadorasTelefonia().getDado();
        if (listOperadoras == null || listOperadoras.isEmpty()) {
            logger.log((Priority)Level.ERROR, (Object)"Erro ao capturar as operadoras telefonia pois a lista das operadoras n\u00e3o cont\u00e9m nenhuma operadora.");
            throw new IllegalArgumentException("Lista de operadoras nula");
        }
        if (listOperadoras.size() == 1) {
            dados.setOperadoraTelefonia(new OperadoraTelefonia((Operadora)listOperadoras.get(0)));
            return SUCCESS;
        }
        Iterator ite = listOperadoras.iterator();
        LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage("CAPOPETEL_TITLE"), true);
        Operadora[] arrayOperadoraTecla = new Operadora[listOperadoras.size()];
        int iTecla = 0;
        while (ite.hasNext()) {
            Operadora ope;
            arrayOperadoraTecla[iTecla] = ope = (Operadora)ite.next();
            layoutMenu.addItem(new ItemMenu(ope.getNome(), String.valueOf(iTecla + 1)));
            ++iTecla;
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        int opcao = perifericos.imprimeMenu(layoutMenu);
        if (opcao == -1) {
            return USER_CANCEL;
        }
        dados.setOperadoraTelefonia(new OperadoraTelefonia(arrayOperadoraTecla[opcao - 1]));
        return SUCCESS;
    }
}

