/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ConfCreditoDigital;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCreditoDigital;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.ICapturaOperadoraTelefoniaCreditoDigital;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.ControladorInicioDia;
import com.csi.ctfclient.operacoes.model.DadosInicioDia;
import com.csi.ctfclient.operacoes.model.DadosPersistencia;
import com.csi.ctfclient.operacoes.model.OperadoraTelefonia;
import com.csi.ctfclient.operacoes.model.controller.ControladorPersistencia;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicCapturaOperadoraTelefoniaCreditoDigital {
    private Logger logger = CTFClientLogger.getCTFClient();
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String ERROR_AC = "ERROR_AC";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String execute(ICapturaOperadoraTelefoniaCreditoDigital dados) throws ExcecaoApiAc {
        DadosInicioDia dadosInicioDia;
        IdentTerminal identTerminal;
        ConfCTFClient config;
        InternacionalizacaoUtil inter;
        block16: {
            block17: {
                inter = InternacionalizacaoUtil.getInstance();
                if (dados.getOperadoraTelefonia() != null) {
                    return FILLED;
                }
                config = ControladorConfCTFClient.getInstance().getConfig();
                identTerminal = null;
                identTerminal = dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isMultiTerminal() ? dados.getEntradaIntegracao().getIdentTerminal() : new IdentTerminal(config.getEstabelecimento(), config.getLoja(), config.getTerminal());
                ControladorInicioDia controladorInicioDia = ControladorInicioDia.getInstance();
                dadosInicioDia = controladorInicioDia.getDadosInicioDia(identTerminal, config.getVersaoPathTerminal());
                if (dados.getEntradaIntegracao() == null) break block16;
                if (!dados.getEntradaIntegracao().isCodigoOperadoraTelefoniaCtrl()) break block17;
                if (dados.getEntradaIntegracao().isMultiTerminal()) {
                    OperadoraTelefonia operadoraTelefonia = new OperadoraTelefonia();
                    operadoraTelefonia.setCodigo(dados.getEntradaIntegracao().getCodigoOperadoraTelefonia());
                    operadoraTelefonia.setAutorizadora(dados.getEntradaIntegracao().getCodigoAutorizadora());
                    operadoraTelefonia.setNome("");
                    dados.setOperadoraTelefonia(operadoraTelefonia);
                    return SUCESS;
                }
                String operadoraTelefoniaIntegracao = dados.getEntradaIntegracao().getCodigoOperadoraTelefonia();
                Object listaOperadoras = null;
                if (!config.isIntegracaoWeb() && dadosInicioDia.isConsultaOperadorasCD()) {
                    if (operadoraTelefoniaIntegracao.length() <= 0) {
                        dados.setErroIntegracao(new CodigoErroIntegracao(5370, "OPERADORA DE TELEFONIA INVALIDA"));
                        return ERROR_AC;
                    }
                    OperadoraTelefonia operadoraTelefonia = new OperadoraTelefonia();
                    operadoraTelefonia.setAutorizadora(operadoraTelefoniaIntegracao);
                    dados.setOperadoraTelefonia(operadoraTelefonia);
                    break block16;
                } else {
                    OperadoraTelefonia operadora;
                    ConfCreditoDigital conf = null;
                    try {
                        conf = ControladorConfCreditoDigital.getInstance().getConfig();
                    }
                    catch (ExcecaoApiAc e) {
                        this.logger.log((Priority)Level.ERROR, (Object)"Erro ao capturar as operadoras de telefonia...");
                        throw e;
                    }
                    Iterator ite = conf.getOperadorasTelefonia().iterator();
                    do {
                        if (!ite.hasNext()) {
                            dados.setErroIntegracao(new CodigoErroIntegracao(5370, "OPERADORA DE TELEFONIA INVALIDA"));
                            return ERROR_AC;
                        }
                        operadora = (OperadoraTelefonia)ite.next();
                    } while (operadoraTelefoniaIntegracao == null || !operadora.getAutorizadora().equals(operadoraTelefoniaIntegracao));
                    dados.setOperadoraTelefonia(operadora);
                    return SUCESS;
                }
            }
            if (dados.getEntradaIntegracao().isMultiTerminal()) {
                dados.setErroIntegracao(new CodigoErroIntegracao(5370, "OPERADORA DE TELEFONIA INVALIDA"));
                return ERROR_AC;
            }
        }
        List listaOperadoras = null;
        if (!config.isIntegracaoWeb() && dadosInicioDia.isConsultaOperadorasCD()) {
            ControladorPersistencia controladorPersistencia = ControladorPersistencia.getInstance();
            DadosPersistencia dadosPersistencia = controladorPersistencia.getDadosPersistencia(identTerminal, config.getVersaoPathTerminal());
            listaOperadoras = (List)dadosPersistencia.getListaOperadorasRecarga().getDado();
        } else {
            ConfCreditoDigital conf = null;
            try {
                conf = ControladorConfCreditoDigital.getInstance().getConfig();
            }
            catch (ExcecaoApiAc e) {
                this.logger.log((Priority)Level.ERROR, (Object)"Erro ao capturar as operadoras de telefonia...");
                throw e;
            }
            listaOperadoras = new ArrayList(conf.getOperadorasTelefonia());
        }
        LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage("CAPOPETELCREDIG_TITLE"), true);
        OperadoraTelefonia[] arrayOperadoraTecla = new OperadoraTelefonia[listaOperadoras.size()];
        int iTecla = 0;
        Iterator iter = listaOperadoras.iterator();
        while (iter.hasNext()) {
            OperadoraTelefonia operadora;
            arrayOperadoraTecla[iTecla] = operadora = (OperadoraTelefonia)iter.next();
            layoutMenu.addItem(new ItemMenu(operadora.getNome(), String.valueOf(iTecla + 1)));
            ++iTecla;
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        int opcao = perifericos.imprimeMenu(layoutMenu);
        if (opcao == -1) {
            return USER_CANCEL;
        }
        dados.setOperadoraTelefonia(arrayOperadoraTecla[opcao - 1]);
        return SUCESS;
    }
}

