/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.ICapturaPedido;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaPedido {
    public static final String SUCCESS = "SUCCESS";
    public static final String FILLED = "FILLED";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";
    public static final String USER_CANCEL = "USER_CANCEL";

    public String execute(ICapturaPedido dados) throws ExcecaoNaoLocal {
        LayoutDisplay layoutDisplay;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (dados.getSaidaApiTef() != null && !dados.getSaidaApiTef().isCapturaPedido()) {
            return NOT_REQUIRED;
        }
        if (dados.getPedido() != null) {
            return FILLED;
        }
        if (dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isPedidoCtrl()) {
            dados.setPedido(dados.getEntradaIntegracao().getPedido());
            return SUCCESS;
        }
        ControladorPerifericos periferico = dados.getPerifericos();
        EventoTeclado eventoTeclado = (EventoTeclado)periferico.capturaDado(layoutDisplay = new LayoutDisplay(inter.getMessage("CAPPED_TITLE")), ConstantesApiAc.CAP_NUMERO_PEDIDO);
        if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
            return USER_CANCEL;
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        String valor = eventoTeclado.getStringLida().substring(num);
        dados.setPedido(valor);
        return SUCCESS;
    }
}

