/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.ICapturaPrazo1aParcela;
import com.csi.ctfclient.operacoes.model.PrazoAgendamento;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicCapturaPrazo1aParcela {
    public static final String SUCCESS = "SUCCESS";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(ICapturaPrazo1aParcela dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (dados.getPrazo1aParcela() != null) {
            return FILLED;
        }
        ArrayList<PrazoAgendamento> listPrazos = new ArrayList<PrazoAgendamento>();
        listPrazos.add(new PrazoAgendamento(30, "30 DIAS"));
        listPrazos.add(new PrazoAgendamento(60, "60 DIAS"));
        if (listPrazos == null || listPrazos.isEmpty()) {
            this.logger.log((Priority)Level.ERROR, (Object)"Erro ao capturar a lista de prazos de agendamento da primeira parcela, a lista est\u00e1 nula ou vazia.");
            throw new IllegalArgumentException("Lista de prazos nula");
        }
        Iterator ite = listPrazos.iterator();
        LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage("CAPPRA1APAR_TITLE"), true);
        PrazoAgendamento[] arrayPrazosAgendamento = new PrazoAgendamento[listPrazos.size()];
        int iTecla = 0;
        while (ite.hasNext()) {
            PrazoAgendamento prazoAgendamento;
            arrayPrazosAgendamento[iTecla] = prazoAgendamento = (PrazoAgendamento)ite.next();
            layoutMenu.addItem(new ItemMenu(prazoAgendamento.getDescricao(), String.valueOf(iTecla + 1)));
            ++iTecla;
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        int opcao = perifericos.imprimeMenu(layoutMenu);
        if (opcao == -1) {
            return USER_CANCEL;
        }
        dados.setPrazo1aParcela(arrayPrazosAgendamento[opcao - 1]);
        return SUCCESS;
    }
}

