/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.ICapturaProdutoDinamico;
import com.csi.ctfclient.operacoes.model.Produto;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaProdutoDinamico {
    public static final String PRODUTO_DEFAULT = "PRODUTO_DEFAULT";
    public static final String PRODUTO_SELECIONADO = "PRODUTO_SELECIONADO";
    public static final String CANCELADO_USUARIO = "CANCELADO_USUARIO";

    public String execute(ICapturaProdutoDinamico dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dados.getPerifericos();
        Produto[] produtos = dados.getSaidaApiTef().getProdutos();
        if (produtos != null && produtos.length != 0) {
            if (produtos.length > 1) {
                LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage("EXIMENDIN_TITLE"), true);
                for (int i = 1; i <= produtos.length; ++i) {
                    Produto produto = produtos[i - 1];
                    layoutMenu.addItem(new ItemMenu(produto.getDescricao(), String.valueOf(i)));
                }
                int opcao = perifericos.imprimeMenu(layoutMenu);
                if (opcao == -1) {
                    return CANCELADO_USUARIO;
                }
                dados.setSaidaApiTef(null);
                dados.setProdutoDinamico(produtos[opcao - 1]);
                return PRODUTO_SELECIONADO;
            }
            dados.setProdutoDinamico(produtos[0]);
            return PRODUTO_DEFAULT;
        }
        return PRODUTO_DEFAULT;
    }
}

