/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.ICapturaProdutoValeGas;
import com.csi.ctfclient.operacoes.model.ProdutoValeGas;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicCapturaProdutoValeGas {
    public static final String SUCCESS = "SUCCESS";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(ICapturaProdutoValeGas dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (dados.getProdutoValeGas() != null) {
            return FILLED;
        }
        List listProdutos = dados.getSaidaApiTef().getProdutosValeGas();
        if (listProdutos == null || listProdutos.isEmpty()) {
            this.logger.log((Priority)Level.ERROR, (Object)"Erro ao capturar os produtos da operadora de vale g\u00e1s, lista de produtos nula ou vazia.");
            throw new IllegalArgumentException("Lista de produtos nula");
        }
        Iterator ite = listProdutos.iterator();
        LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage("CAPPROVALGAS_TITLE"), true);
        ProdutoValeGas[] arrayProdutoTecla = new ProdutoValeGas[listProdutos.size()];
        DecimalFormat df = new DecimalFormat("#,##0.00");
        int iTecla = 0;
        while (ite.hasNext()) {
            ProdutoValeGas produto;
            arrayProdutoTecla[iTecla] = produto = (ProdutoValeGas)ite.next();
            String valorString = df.format(produto.getValor());
            String msgLinha = StringUtil.completaString(produto.getDescricao(), 12, ' ', 4) + " $" + StringUtil.completaString(valorString, 6, ' ', 3);
            layoutMenu.addItem(new ItemMenu(msgLinha, String.valueOf(iTecla + 1)));
            ++iTecla;
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        int opcao = perifericos.imprimeMenu(layoutMenu);
        if (opcao == -1) {
            return USER_CANCEL;
        }
        ProdutoValeGas produtoValeGas = arrayProdutoTecla[opcao - 1];
        dados.setProdutoValeGas(produtoValeGas);
        dados.setValorTransacao(produtoValeGas.getValor());
        return SUCCESS;
    }
}

