/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.ICapturaRg;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaRg {
    public static final String SUCCESS = "SUCCESS";
    public static final String FILLED = "FILLED";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";
    public static final String USER_CANCEL = "USER_CANCEL";

    public String execute(ICapturaRg dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (dados.getSaidaApiTef() != null && !dados.getSaidaApiTef().isCapturaRg()) {
            return NOT_REQUIRED;
        }
        if (dados.getRg() != 0) {
            return FILLED;
        }
        if (dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isRgCtrl()) {
            dados.setRg(dados.getEntradaIntegracao().getRg());
            return SUCCESS;
        }
        ControladorPerifericos periferico = dados.getPerifericos();
        String valor = null;
        int caracteresDigitados = 0;
        while (caracteresDigitados == 0) {
            LayoutDisplay layoutDisplay = new LayoutDisplay(inter.getMessage("CAPRG_TITLE"));
            EventoTeclado eventoTeclado = (EventoTeclado)periferico.capturaDado(layoutDisplay, ConstantesApiAc.CAP_RG);
            if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                return USER_CANCEL;
            }
            int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
            valor = eventoTeclado.getStringLida().substring(num);
            caracteresDigitados = valor.length();
            int valorInt = 0;
            if (caracteresDigitados <= 0) continue;
            try {
                valorInt = Integer.parseInt(valor);
                dados.setRg(valorInt);
            }
            catch (Exception e) {
                caracteresDigitados = 0;
            }
        }
        return SUCCESS;
    }
}

