/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IServicoFuelControl;
import com.csi.ctfclient.operacoes.model.DadosServicosFuelControl;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.util.Iterator;
import java.util.List;

public class MicCapturaServicoFuelControl {
    public static final String UNECESSARY = "UNECESSARY";
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    public static final String USERCANCEL = "USERCANCEL";

    public String execute(IServicoFuelControl dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dados.getPerifericos();
        SaidaApiTefC saida = dados.getSaidaApiTef();
        List servicos = dados.getSaidaApiTef().getServicosFuelControl();
        if (servicos != null) {
            String digitos = null;
            while (digitos == null) {
                LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage("CAPSERVICO_FUEL_CONTROL_TITLE"), false);
                for (DadosServicosFuelControl servico : servicos) {
                    layoutMenu.addItem(new ItemMenu(servico.getCodigo() + "-" + servico.getDescricao()));
                }
                EventoTeclado evTeclado = perifericos.imprimeMenu(layoutMenu, new String[]{inter.getMessage("CAP_CODIGO_SERVICO_FUEL_CONTROL")}, ConstantesApiAc.CAP_SERVICO_CONVENIO_COMBUSTIVEL);
                if (evTeclado.getTeclaFinalizadora().equals("ENTRA")) {
                    digitos = evTeclado.getStringLida();
                    int num = evTeclado.getStringLida().length() - evTeclado.getNumCaracteresDigitados();
                    digitos = digitos.substring(num);
                    if ((digitos = StringUtil.completaString(digitos, 2, '0', 3)).equals("00")) {
                        digitos = null;
                        continue;
                    }
                    if (saida == null || !saida.isRestringeCapturaServico() || this.isServicoDisponivel(digitos, servicos)) continue;
                    digitos = null;
                    continue;
                }
                if (evTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                    return USERCANCEL;
                }
                return ERROR;
            }
            dados.setServicoFuelControl(digitos);
            return SUCCESS;
        }
        return UNECESSARY;
    }

    private boolean isServicoDisponivel(String servicoDigitado, List servicos) {
        Iterator iteServicos = servicos.iterator();
        while (iteServicos.hasNext()) {
            if (!((DadosServicosFuelControl)iteServicos.next()).getCodigo().equals(servicoDigitado)) continue;
            return true;
        }
        return false;
    }
}

