/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.ITelefoneMovel;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaTelefoneMovel {
    public static final String SUCCESS = "SUCCESS";
    public static final String FILLED = "FILLED";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";
    public static final String USER_CANCEL = "USER_CANCEL";

    public String execute(ITelefoneMovel dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (dados.getSaidaApiTef() != null && !dados.getSaidaApiTef().isCapturaTelefoneMovel()) {
            return NOT_REQUIRED;
        }
        if (dados.getTelefoneMovel() != null) {
            return FILLED;
        }
        if (dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isTelefoneFixoCtrl()) {
            dados.setTelefoneMovel(dados.getEntradaIntegracao().getTelefoneMovel());
            return SUCCESS;
        }
        ControladorPerifericos periferico = dados.getPerifericos();
        String valor = null;
        int caracteresDigitados = -1;
        while (caracteresDigitados != 10) {
            LayoutDisplay layoutDisplay = new LayoutDisplay(inter.getMessage("CAPTELMOV_TITLE"));
            EventoTeclado eventoTeclado = (EventoTeclado)periferico.capturaDado(layoutDisplay, ConstantesApiAc.CAP_TELEFONE_MOVEL);
            if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                return USER_CANCEL;
            }
            caracteresDigitados = eventoTeclado.getNumCaracteresDigitados();
            int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
            valor = eventoTeclado.getStringLida().substring(num).trim();
        }
        dados.setTelefoneMovel(valor);
        return SUCCESS;
    }
}

