/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.processleituracartao.ProcessLeituraPin;
import com.csi.ctfclient.operacoes.entrada.ICapturaTelefonePin;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.ControladorModeloPinPad;
import com.csi.ctfclient.operacoes.model.Criptografia;
import com.csi.ctfclient.tools.devices.EventoDispositivoEntrada;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.emv.DadoSolicitaPin;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.devices.generic.Ansi98Crypto;
import com.csi.ctfclient.tools.devices.generic.Des;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaTelefonePin {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String USER_CANCEL_INTERNAL = "USER_CANCEL_INTERNAL";
    public static final String INVALID_CONFIRMATION = "INVALID_CONFIRMATION";
    public static final String INVALID_TELEPHONE = "INVALID_TELEPHONE";
    public static final String ERROR = "ERROR";
    public static final String ERROR_AC = "ERROR_AC";
    private static final String MSG_DDD_TELEFONE_PINPAD = "DDD E TELEFONE";
    private static final String MSG_DDD_PINPAD = "DIGITE DDD";
    private static final String MSG_TELEFONE_PINPAD = "DIGITE TELEFONE";
    private boolean flagWKAuttar = false;
    private String wkAuttar = null;
    private InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();

    public String execute(ICapturaTelefonePin dados) {
        if (dados.getTelefone() != null) {
            return FILLED;
        }
        if (dados.getEntradaIntegracao() != null) {
            if (dados.getEntradaIntegracao().isDddCtrl() && dados.getEntradaIntegracao().isTelefoneCtrl()) {
                dados.setDDD(dados.getEntradaIntegracao().getDdd());
                dados.setTelefone(dados.getEntradaIntegracao().getTelefone());
                return SUCESS;
            }
            if (dados.getEntradaIntegracao().isMultiTerminal()) {
                dados.setErroIntegracao(new CodigoErroIntegracao(5371, "DDD OU TELEFONE INVALIDO"));
                return ERROR_AC;
            }
        }
        String dddTelefone = null;
        ControladorPerifericos perifericos = dados.getPerifericos();
        try {
            int tamMaxTelefone;
            int tamMinTelefone;
            int tamMaxDdd;
            int tamMinDdd;
            ConfCTFClient config = ControladorConfCTFClient.getInstance().getConfig();
            boolean capturaDoisDisplays = config.isCapturaTelefoneDoisDisplay();
            if (config.getVersaoLayoutCD() == 3) {
                tamMinDdd = 2;
                tamMaxDdd = 2;
                tamMinTelefone = 8;
                tamMaxTelefone = 9;
            } else {
                tamMinDdd = 2;
                tamMaxDdd = 2;
                tamMinTelefone = 8;
                tamMaxTelefone = 8;
            }
            PinEMV pin = null;
            if (config.isCapturaTelefonePinpad()) {
                pin = perifericos.getPin();
                dddTelefone = this.capturaTelefonePinpad(dados, pin, capturaDoisDisplays, perifericos, tamMinDdd, tamMaxDdd, tamMinTelefone, tamMaxTelefone);
            } else {
                dddTelefone = this.capturaTelefoneTelaOperador(capturaDoisDisplays, perifericos, tamMinDdd, tamMaxDdd, tamMinTelefone, tamMaxTelefone);
            }
            if (!config.isCapturaTelefoneDuplaCaptura()) {
                dados.setDDD(dddTelefone.substring(0, 2));
                dados.setTelefone(dddTelefone.substring(2, dddTelefone.length()));
                return SUCESS;
            }
            String dddTelefone1 = dddTelefone;
            String dddTelefone2 = dddTelefone = config.isCapturaTelefonePinpad() ? this.capturaTelefonePinpad(dados, pin, capturaDoisDisplays, perifericos, tamMinDdd, tamMaxDdd, tamMinTelefone, tamMaxTelefone) : this.capturaTelefoneTelaOperador(capturaDoisDisplays, perifericos, tamMinDdd, tamMaxDdd, tamMinTelefone, tamMaxTelefone);
            if (dddTelefone1.equals(dddTelefone2)) {
                dados.setDDD(dddTelefone.substring(0, 2));
                dados.setTelefone(dddTelefone.substring(2, dddTelefone.length()));
                return SUCESS;
            }
            EventoTeclado eventoTeclado = (EventoTeclado)this.exibeMensagem(perifericos, this.inter.getMessage("CAPTELPIN_CONFIRMACAO_INVALIDA"));
            if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
                return USER_CANCEL;
            }
            return INVALID_CONFIRMATION;
        }
        catch (ExcecaoPerifericos e) {
            e.printStackTrace();
            return ERROR;
        }
        catch (ExcecaoApiAc e) {
            e.printStackTrace();
            return ERROR;
        }
        catch (UserCancelException e) {
            return USER_CANCEL;
        }
        catch (UserCancelInternalException e) {
            return USER_CANCEL_INTERNAL;
        }
        catch (ReadErrorException e) {
            return ERROR;
        }
    }

    private String capturaTelefoneTelaOperador(boolean capturaDoisDisplays, ControladorPerifericos perifericos, int tamMinDdd, int tamMaxDdd, int tamMinTelefone, int tamMaxTelefone) throws UserCancelException, ExcecaoApiAc {
        String dddTelefone;
        ConfCTFClient config = ControladorConfCTFClient.getInstance().getConfig();
        if (capturaDoisDisplays) {
            ConstantesApiAc.TipoCampo mascaraTelefone;
            ConstantesApiAc.TipoCampo mascaraDdd;
            if (config.getVersaoLayoutCD() == 3) {
                mascaraDdd = ConstantesApiAc.CAP_DDD_TELEFONE_2_DIGITOS;
                mascaraTelefone = ConstantesApiAc.CAP_TELEFONE_9_DIGITOS;
            } else {
                mascaraDdd = ConstantesApiAc.CAP_DDD_TELEFONE_2_DIGITOS;
                mascaraTelefone = ConstantesApiAc.CAP_TELEFONE;
            }
            String ddd = this.capturaTelaOperador(perifericos, tamMinDdd, tamMaxDdd, MSG_DDD_PINPAD, mascaraDdd);
            String telefone = this.capturaTelaOperador(perifericos, tamMinTelefone, tamMaxTelefone, MSG_TELEFONE_PINPAD, mascaraTelefone);
            dddTelefone = ddd + telefone;
        } else {
            ConstantesApiAc.TipoCampo mascaraDddTelefone = config.getVersaoLayoutCD() == 3 ? ConstantesApiAc.CAP_DDD_TELEFONE_9_DIGITOS : ConstantesApiAc.CAP_TELEFONE_ESTABELECIMENTO;
            dddTelefone = this.capturaTelaOperador(perifericos, tamMinDdd + tamMinTelefone, tamMaxDdd + tamMaxTelefone, MSG_DDD_TELEFONE_PINPAD, mascaraDddTelefone);
        }
        return dddTelefone;
    }

    private String capturaTelaOperador(ControladorPerifericos perifericos, int tamMin, int tamMax, String mensagemDisplay, ConstantesApiAc.TipoCampo tipoCampo) throws UserCancelException, ExcecaoNaoLocal {
        String valor = null;
        int caracteresDigitados = -1;
        while (caracteresDigitados < tamMin || caracteresDigitados > tamMax) {
            LayoutDisplay displayModel = new LayoutDisplay(mensagemDisplay);
            EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, tipoCampo, 0, true, 0, false);
            if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                throw new UserCancelException();
            }
            caracteresDigitados = eventoTeclado.getNumCaracteresDigitados();
            int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
            valor = eventoTeclado.getStringLida().substring(0, eventoTeclado.getStringLida().length() - num);
        }
        return valor;
    }

    private String capturaTelefonePinpad(ICapturaTelefonePin dados, PinEMV pin, boolean capturaDoisDisplays, ControladorPerifericos perifericos, int tamMinDdd, int tamMaxDdd, int tamMinTelefone, int tamMaxTelefone) throws ExcecaoNaoLocal, ReadErrorException, UserCancelException, UserCancelInternalException {
        String retorno = null;
        while (true) {
            retorno = this.capturaTelefonePin(dados, pin, capturaDoisDisplays, tamMinDdd, tamMaxDdd, tamMinTelefone, tamMaxTelefone);
            if (capturaDoisDisplays || retorno == null || retorno.length() >= tamMinDdd + tamMinTelefone && retorno.length() <= tamMaxDdd + tamMaxTelefone) break;
            this.exibeMensagem(perifericos, this.inter.getMessage("CAPTELPIN_TELEFONE_INVALIDO"));
        }
        return retorno;
    }

    private String capturaTelefonePin(ICapturaTelefonePin dados, PinEMV pin, boolean capturaDoisDisplays, int tamMaxDdd, int tamMinDdd, int tamMinTelefone, int tamMaxTelefone) throws ReadErrorException, UserCancelException, UserCancelInternalException {
        Criptografia criptografia = null;
        SaidaApiTefC saidaApiTefC = dados.getSaidaApiTef();
        this.flagWKAuttar = saidaApiTefC != null && saidaApiTefC.isChaveAuttarWkAutorizadora();
        try {
            criptografia = ControladorModeloPinPad.getInstance().getCriptografia(pin);
            if (this.flagWKAuttar) {
                byte modoCriptografia = saidaApiTefC.getModoCriptografiaSenha();
                int indiceMkAuttar = saidaApiTefC.getIndiceMasterKey() == '*' ? 0 : saidaApiTefC.getIndiceMasterKey() - 48;
                this.wkAuttar = saidaApiTefC.getWorkingkey();
                criptografia = new Criptografia(modoCriptografia, indiceMkAuttar, this.wkAuttar, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DadoSolicitaPin[] dadoSolicitaPins = capturaDoisDisplays ? new DadoSolicitaPin[]{new DadoSolicitaPin(tamMinDdd, tamMaxDdd, MSG_DDD_PINPAD), new DadoSolicitaPin(tamMinTelefone, tamMaxTelefone, MSG_TELEFONE_PINPAD)} : new DadoSolicitaPin[]{new DadoSolicitaPin(tamMinDdd + tamMinTelefone, tamMaxDdd + tamMaxTelefone, MSG_DDD_TELEFONE_PINPAD)};
        ProcessManager processManager = ProcessManager.getInstance();
        ProcessLeituraPin processLeituraPin = new ProcessLeituraPin(null, criptografia, dadoSolicitaPins, false, false);
        processLeituraPin.setActiveDialogUserCancel(false);
        if (!capturaDoisDisplays) {
            processLeituraPin.setTituloAguardaPin(this.inter.getMessage("CAPTELPIN_TITLE"));
        } else {
            processLeituraPin.setTituloAguardaPin("AGUARDE...");
        }
        try {
            processManager.subProcess(dados.getIdProcess(), processLeituraPin);
        }
        catch (Exception e) {
            throw new ReadErrorException();
        }
        if (processLeituraPin.getState() == 3) {
            throw new UserCancelException();
        }
        if (processLeituraPin.getState() == 5) {
            throw new UserCancelInternalException();
        }
        if (processLeituraPin.getState() == 1) {
            throw new ReadErrorException();
        }
        String dddTelefone = this.decriptografaSenhaCTF(processLeituraPin.getPinInfo().getPinCriptografado());
        return dddTelefone;
    }

    private String decriptografaSenhaCTF(String senhaCryptoPP) {
        String senhaDecriptografada = "";
        byte[] senhaPPBytes = Ansi98Crypto.chaveStrHex2Bin(senhaCryptoPP);
        byte[] chaveBytes = null;
        if (this.flagWKAuttar) {
            byte[] wkAuttarBytes = Ansi98Crypto.chaveStrHex2Bin(this.wkAuttar);
            chaveBytes = Ansi98Crypto.chaveStrHex2Bin("3132333435363738");
            chaveBytes = Des.decrypt(chaveBytes, wkAuttarBytes);
        } else {
            chaveBytes = Ansi98Crypto.chaveStrHex2Bin("3132333435363738");
        }
        senhaDecriptografada = Ansi98Crypto.chaveBin2StrHex(Des.decrypt(chaveBytes, senhaPPBytes));
        if (senhaDecriptografada != null) {
            int tamanho = Integer.decode("0x" + senhaDecriptografada.substring(0, 2));
            senhaDecriptografada = senhaDecriptografada.substring(2, 2 + tamanho);
        }
        return senhaDecriptografada;
    }

    private EventoDispositivoEntrada exibeMensagem(ControladorPerifericos perifericos, String mensagem) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(mensagem);
        return perifericos.confirmaDado(displayModel);
    }

    public static void main(String[] args) {
        MicCapturaTelefonePin mic = new MicCapturaTelefonePin();
        mic.decriptografaSenhaCTF("F04188F8864ED6D5");
        mic.decriptografaSenhaCTF("1D10A1BBB0BC401F");
        System.out.println("");
    }

    private class ReadErrorException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private ReadErrorException() {
        }
    }

    private class UserCancelInternalException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private UserCancelInternalException() {
        }
    }

    private class UserCancelException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private UserCancelException() {
        }
    }
}

