/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.ITipoConsultaCredito;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaTipoConsultaCredito {
    public static final String SUCCESS = "SUCCESS";
    public static final String FILLED = "FILLED";
    public static final String INVALID_TIPO_CONSULTA_AC = "INVALID_TIPO_CONSULTA_AC";
    public static final String USER_CANCEL = "USER_CANCEL";

    public String execute(ITipoConsultaCredito dados) throws ExcecaoNaoLocal {
        if (dados.getTipoConsultaCredito() != 0) {
            return FILLED;
        }
        if (dados.getEntradaIntegracao() != null) {
            if (dados.getEntradaIntegracao().isTipoConsultaSpcCtrl()) {
                int tipoConsultaSpc = dados.getEntradaIntegracao().getTipoConsultaSpc();
                if (tipoConsultaSpc == 1 || tipoConsultaSpc == 2) {
                    dados.setTipoConsultaCredito(tipoConsultaSpc);
                    return SUCCESS;
                }
                dados.setErroIntegracao(new CodigoErroIntegracao(5384, "O tipo da consulta SPC \u00e9 inv\u00e1lido, utilizar 1 \u2013 Autom\u00e1tica ou 2 \u2013 mandat\u00f3ria"));
                return INVALID_TIPO_CONSULTA_AC;
            }
            if (dados.getEntradaIntegracao().isMultiTerminal()) {
                dados.setErroIntegracao(new CodigoErroIntegracao(5384, "O tipo da consulta SPC \u00e9 inv\u00e1lido, utilizar 1 \u2013 Autom\u00e1tica ou 2 \u2013 mandat\u00f3ria"));
                return INVALID_TIPO_CONSULTA_AC;
            }
        }
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage("CAPTIPCONSPC_TITLE"), true);
        layoutMenu.addItem(new ItemMenu(inter.getMessage("CAPTIPCONSPC_CONSULTA_AUTOMATICA"), "1"));
        layoutMenu.addItem(new ItemMenu(inter.getMessage("CAPTIPCONSPC_CONSULTA_MANDATORIA"), "2"));
        int opcao = periferico.imprimeMenu(layoutMenu);
        if (opcao == -1) {
            return USER_CANCEL;
        }
        switch (opcao) {
            case 1: {
                dados.setTipoConsultaCredito(1);
                break;
            }
            case 2: {
                dados.setTipoConsultaCredito(2);
            }
        }
        return SUCCESS;
    }
}

