/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.ITipoDocumento;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaTipoDocumento {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String ERROR_AC = "ERROR_AC";

    public String execute(ITipoDocumento dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (dados.getTipoDocumento() > 0) {
            return FILLED;
        }
        if (dados.getEntradaIntegracao() != null) {
            if (dados.getEntradaIntegracao().isTipoDocumentoCtrl()) {
                if (dados.getEntradaIntegracao().getTipoDocumento() == 1 || dados.getEntradaIntegracao().getTipoDocumento() == 2) {
                    dados.setTipoDocumento(dados.getEntradaIntegracao().getTipoDocumento());
                    return SUCESS;
                }
                dados.setErroIntegracao(new CodigoErroIntegracao(5361, "TIPO DE DOCUMENTO INVALIDO"));
                return ERROR_AC;
            }
            if (dados.getEntradaIntegracao().isMultiTerminal()) {
                dados.setErroIntegracao(new CodigoErroIntegracao(5361, "TIPO DE DOCUMENTO AUSENTE"));
                return ERROR_AC;
            }
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage("CAPTIPDOC_TITLE"), true);
        layoutMenu.addItem(new ItemMenu(inter.getMessage("CAPTIPDOC_CPF"), "1"));
        layoutMenu.addItem(new ItemMenu(inter.getMessage("CAPTIPDOC_CNPJ"), "2"));
        int opcao = perifericos.imprimeMenu(layoutMenu);
        if (opcao == -1) {
            return USER_CANCEL;
        }
        switch (opcao) {
            case 1: {
                dados.setTipoDocumento(2);
                break;
            }
            case 2: {
                dados.setTipoDocumento(1);
            }
        }
        return SUCESS;
    }
}

