/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDadoPlano;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.PlanoAVista;
import com.csi.ctfclient.operacoes.model.PlanoAdministradora;
import com.csi.ctfclient.operacoes.model.PlanoFinanciadoLojista;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaTipoFinanciamentoCreditoCelular {
    public static final String SUCESS_AVISTA = "SUCESS_AVISTA";
    public static final String SUCESS_APRAZOLOJISTA = "SUCESS_APRAZOLOJISTA";
    public static final String SUCESS_APRAZOADMINISTRADO = "SUCESS_APRAZOADMINISTRADO";
    public static final String FILLED = "FILLED";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String ERROR = "ERROR";
    public static final String ERROR_AC = "ERROR_AC";
    public static final String FINANCIAMENTO_INVALIDO_AC = "FINANCIAMENTO_INVALIDO_AC";
    private static final String TIPO_FINANCIAMENTO_NAO_COERENTE = "O TIPO DE FINANCIAMENTO NAO E COERENTE COM O NUMERO DE PARCELAS";
    private static final String MSG_OPERATION_NOT_ALLOWED = "OPERACAO NAO PERMITIDA";

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public String execute(IDadoPlano dados) throws ExcecaoNaoLocal {
        void var7_13;
        void var7_12;
        boolean buscaEntrada;
        boolean habilitadoAdministradora;
        boolean habilitadoFinanciadoLojista;
        boolean habilitadoAVista;
        InternacionalizacaoUtil inter;
        block25: {
            block26: {
                block27: {
                    inter = InternacionalizacaoUtil.getInstance();
                    if (dados.getTipoFinanciamento() != null) {
                        return FILLED;
                    }
                    habilitadoAVista = dados.getSaidaApiTef().isPedePlanoAVista();
                    habilitadoFinanciadoLojista = dados.getSaidaApiTef().isPedePlanoLojista();
                    habilitadoAdministradora = dados.getSaidaApiTef().isPedePlanoAdministradora();
                    if (dados.getEntradaIntegracao() == null) break block26;
                    if (dados.getEntradaIntegracao().getOperacao() != 232) break block27;
                    if (dados.getEntradaIntegracao().isNumeroParcelasCtrl()) {
                        if (dados.getEntradaIntegracao().getNumeroParcelas() == 0) {
                            buscaEntrada = false;
                            break block25;
                        } else {
                            if (dados.getEntradaIntegracao().getNumeroParcelas() != 1) {
                                dados.setErroIntegracao(new CodigoErroIntegracao(5366, TIPO_FINANCIAMENTO_NAO_COERENTE));
                                return FINANCIAMENTO_INVALIDO_AC;
                            }
                            buscaEntrada = true;
                        }
                        break block25;
                    } else {
                        buscaEntrada = false;
                    }
                    break block25;
                }
                if (dados.getEntradaIntegracao().getOperacao() != 234 && dados.getEntradaIntegracao().getOperacao() != 233) {
                    dados.setErroIntegracao(new CodigoErroIntegracao(5306, MSG_OPERATION_NOT_ALLOWED));
                    return ERROR_AC;
                }
                if (dados.getEntradaIntegracao().isNumeroParcelasCtrl() && dados.getEntradaIntegracao().getNumeroParcelas() == 1) {
                    dados.setErroIntegracao(new CodigoErroIntegracao(5366, TIPO_FINANCIAMENTO_NAO_COERENTE));
                    return FINANCIAMENTO_INVALIDO_AC;
                }
                buscaEntrada = true;
                break block25;
            }
            buscaEntrada = false;
        }
        if (buscaEntrada) {
            Object var7_7 = null;
            int operacao = dados.getEntradaIntegracao().getOperacao();
            if (operacao == 232) {
                PlanoAVista planoAVista = new PlanoAVista();
                dados.setTipoFinanciamento(planoAVista);
                return SUCESS_AVISTA;
            }
            if (operacao == 233) {
                PlanoFinanciadoLojista planoFinanciadoLojista = new PlanoFinanciadoLojista();
                dados.setTipoFinanciamento(planoFinanciadoLojista);
                return SUCESS_APRAZOLOJISTA;
            }
            if (operacao == 234) {
                PlanoAdministradora planoAdministradora = new PlanoAdministradora();
                dados.setTipoFinanciamento(planoAdministradora);
                return SUCESS_APRAZOADMINISTRADO;
            }
            dados.setErroIntegracao(new CodigoErroIntegracao(5306, MSG_OPERATION_NOT_ALLOWED));
            return ERROR_AC;
        }
        int n = 1;
        LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage("LEITIPFIN_TITLE"), true);
        if (habilitadoAVista) {
            ++var7_12;
            layoutMenu.addItem(new ItemMenu(inter.getMessage("LEITIPFIN_MENU_AVISTA"), String.valueOf(n)));
        }
        if (habilitadoAdministradora) {
            ++var7_13;
            layoutMenu.addItem(new ItemMenu(inter.getMessage("LEITIPFIN_MENU_ADMINISTRADORA"), String.valueOf((int)var7_12)));
        }
        if (habilitadoFinanciadoLojista) {
            void var7_14;
            ++var7_14;
            layoutMenu.addItem(new ItemMenu(inter.getMessage("LEITIPFIN_MENU_FINANCIADO_LOJISTA"), String.valueOf((int)var7_13)));
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        if (layoutMenu.getItens().isEmpty()) {
            dados.setTipoFinanciamento(null);
            return ERROR;
        }
        if (layoutMenu.getItens().size() == 1) {
            if (habilitadoAVista) {
                dados.setTipoFinanciamento(new PlanoAVista());
                return SUCESS_AVISTA;
            }
            if (habilitadoAdministradora) {
                dados.setTipoFinanciamento(new PlanoAdministradora());
                return SUCESS_APRAZOADMINISTRADO;
            }
            if (!habilitadoFinanciadoLojista) return ERROR;
            dados.setTipoFinanciamento(new PlanoFinanciadoLojista());
            return SUCESS_APRAZOLOJISTA;
        } else {
            int opcao = perifericos.imprimeMenu(layoutMenu);
            if (opcao == -1) {
                return USERCANCEL;
            }
            ItemMenu itemSelecionado = (ItemMenu)layoutMenu.getItens().get(opcao - 1);
            if (itemSelecionado.getTexto().equals(inter.getMessage("LEITIPFIN_MENU_AVISTA"))) {
                dados.setTipoFinanciamento(new PlanoAVista());
                return SUCESS_AVISTA;
            }
            if (itemSelecionado.getTexto().equals(inter.getMessage("LEITIPFIN_MENU_FINANCIADO_LOJISTA"))) {
                dados.setTipoFinanciamento(new PlanoFinanciadoLojista());
                return SUCESS_APRAZOLOJISTA;
            }
            if (!itemSelecionado.getTexto().equals(inter.getMessage("LEITIPFIN_MENU_ADMINISTRADORA"))) return ERROR;
            dados.setTipoFinanciamento(new PlanoAdministradora());
            return SUCESS_APRAZOADMINISTRADO;
        }
    }
}

