/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDadoPlano;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.Plano;
import com.csi.ctfclient.operacoes.model.PlanoAVista;
import com.csi.ctfclient.operacoes.model.PlanoCDC;
import com.csi.ctfclient.operacoes.model.PlanoParcelado;
import com.csi.ctfclient.operacoes.model.PlanoParceleMais;
import com.csi.ctfclient.operacoes.model.PlanoPreDatado;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.util.HashMap;

public class MicCapturaTipoFinanciamentoDebito {
    public static final String SUCESS = "SUCESS";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String FILLED = "FILLED";
    public static final String ERROR_AC = "ERROR_AC";
    private static final String MSG_OPERATION_NOT_ALLOWED = "OPERACAO NAO PERMITIDA";

    public String execute(IDadoPlano dados) throws ExcecaoApiAc {
        Plano plano;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (dados.getTipoFinanciamento() != null) {
            return FILLED;
        }
        boolean parceleMaisHabilitado = false;
        if (dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().getOperacao() != 224 && dados.getEntradaIntegracao().getOperacao() != 128) {
            plano = null;
            int operacao = dados.getEntradaIntegracao().getOperacao();
            if (operacao == 101) {
                plano = new PlanoAVista();
            } else if (operacao == 103) {
                if (dados.getSaidaApiTef().getMaximaDiaPre() > 0 || dados.getSaidaApiTef().getMaximoMesesAgendamento() > 0) {
                    plano = new PlanoPreDatado();
                }
            } else if (operacao == 104 || operacao == 105) {
                if (dados.getSaidaApiTef().getQtdMaximaParcelaSemJuros() > 0) {
                    plano = parceleMaisHabilitado ? new PlanoParceleMais() : new PlanoParcelado();
                }
            } else if ((operacao == 406 || operacao == 108 || operacao == 109) && dados.getSaidaApiTef().getQtdMaximaParcelaComJuros() > 0) {
                plano = new PlanoCDC();
            }
            if (plano == null) {
                dados.setErroIntegracao(new CodigoErroIntegracao(5306, MSG_OPERATION_NOT_ALLOWED));
                return ERROR_AC;
            }
        } else {
            ControladorPerifericos perifericos = dados.getPerifericos();
            LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage("CAPTIPFINDEB_TITLE"), true);
            HashMap<String, Plano> mapaMenu = new HashMap<String, Plano>();
            int countOpcoesMenu = 1;
            mapaMenu.put(String.valueOf(countOpcoesMenu), new PlanoAVista());
            layoutMenu.addItem(new ItemMenu("A VISTA", String.valueOf(countOpcoesMenu)));
            ++countOpcoesMenu;
            if (dados.getSaidaApiTef().getQtdMaximaParcelaComJuros() > 0) {
                mapaMenu.put(String.valueOf(countOpcoesMenu), new PlanoCDC());
                layoutMenu.addItem(new ItemMenu("CDC", String.valueOf(countOpcoesMenu)));
                ++countOpcoesMenu;
            }
            if (dados.getSaidaApiTef().getMaximaDiaPre() > 0 || dados.getSaidaApiTef().getMaximoMesesAgendamento() > 0) {
                mapaMenu.put(String.valueOf(countOpcoesMenu), new PlanoPreDatado());
                layoutMenu.addItem(new ItemMenu("PRE-DATADO", String.valueOf(countOpcoesMenu)));
                ++countOpcoesMenu;
            }
            if (dados.getSaidaApiTef().getQtdMaximaParcelaSemJuros() > 0) {
                if (parceleMaisHabilitado) {
                    mapaMenu.put(String.valueOf(countOpcoesMenu), new PlanoParceleMais());
                    layoutMenu.addItem(new ItemMenu("PARCELE MAIS", String.valueOf(countOpcoesMenu)));
                } else {
                    mapaMenu.put(String.valueOf(countOpcoesMenu), new PlanoParcelado());
                    layoutMenu.addItem(new ItemMenu("PARCELADO", String.valueOf(countOpcoesMenu)));
                }
                ++countOpcoesMenu;
            }
            if (layoutMenu.getItens().size() == 1) {
                dados.setTipoFinanciamento((Plano)mapaMenu.get(String.valueOf(1)));
                return SUCESS;
            }
            int opcao = perifericos.imprimeMenu(layoutMenu);
            if (opcao == -1) {
                return USERCANCEL;
            }
            dados.setTipoFinanciamento((Plano)mapaMenu.get(String.valueOf(opcao)));
            return SUCESS;
        }
        dados.setTipoFinanciamento(plano);
        return SUCESS;
    }
}

