/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDadoPlano;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.PlanoPreDatado;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaTipoGarantia {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String INVALID_TRANSACTION_AC = "INVALID_TRANSACTION_AC";

    public String execute(IDadoPlano dados) throws ExcecaoApiAc {
        boolean habilitado;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dados.getPerifericos();
        PlanoPreDatado planoPreDatado = (PlanoPreDatado)dados.getTipoFinanciamento();
        if (planoPreDatado.getTipoGarantia() != -1) {
            return FILLED;
        }
        if (dados.getSaidaApiTef().getHabilitaCDC_PRE() == 2) {
            return UNECESSARY;
        }
        boolean bl = habilitado = dados.getSaidaApiTef().getHabilitaCDC_PRE() == 1;
        if (dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isTipoGarantiaCtrl()) {
            if (habilitado) {
                planoPreDatado.setTipoGarantia(dados.getEntradaIntegracao().getTipoGarantia());
            } else {
                if (dados.getEntradaIntegracao().getTipoGarantia() == 2) {
                    dados.setErroIntegracao(new CodigoErroIntegracao(5315, inter.getMessage("CAPTIPGAR_INVALID_TRANSACTION")));
                    return INVALID_TRANSACTION_AC;
                }
                planoPreDatado.setTipoGarantia(1);
            }
        } else {
            if (!habilitado) {
                LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("CAPTIPGAR_VENDA_GARANTIDA"), 1500L);
                perifericos.imprimeDisplay(displayModel);
                planoPreDatado.setTipoGarantia(1);
                return UNECESSARY;
            }
            if (planoPreDatado.getTipoGarantia() == -1 && habilitado) {
                LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("CAPTIPGAR_TITLE"));
                displayModel.addLinha(new Linha("[1] - COM GARANTIA"));
                displayModel.addLinha(new Linha("[2] - SEM GARANTIA"));
                boolean continuar = true;
                while (continuar) {
                    EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_TIPO_GARANTIA);
                    if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                        return USERCANCEL;
                    }
                    int opcao = Integer.parseInt(eventoTeclado.getStringLida());
                    switch (opcao) {
                        case 1: {
                            planoPreDatado.setTipoGarantia(1);
                            continuar = false;
                            break;
                        }
                        case 2: {
                            planoPreDatado.setTipoGarantia(2);
                            continuar = false;
                        }
                    }
                }
            }
        }
        return SUCESS;
    }
}

